/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.obscuria.obscureapi.api.client.ExternalFile;
import com.obscuria.obscureapi.api.client.ExternalTexture;
import com.obscuria.obscureapi.api.client.ExternalTxt;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import com.obscuria.obscureapi.client.screen.ObscuriaCollectionScreen;
import com.obscuria.obscureapi.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

@OnlyIn(value=Dist.CLIENT)
public final class ObscuriaCollection {
    private static final String GITHUB = "https://raw.githubusercontent.com/ObscuriaLithium/Minecraft/main/";
    private static final List<Mod> COLLECTION_MODS = new ArrayList<Mod>();
    public static ExternalFile ABOUT = ExternalFile.create("https://raw.githubusercontent.com/ObscuriaLithium/Minecraft/main/about.json");
    public static ExternalTxt MODS = ExternalTxt.create("https://raw.githubusercontent.com/ObscuriaLithium/Minecraft/main/mods.txt", false, txt -> {
        COLLECTION_MODS.clear();
        txt.get().forEach(id -> COLLECTION_MODS.add(Mod.load(id)));
    });
    public static ExternalTxt RUNESTONES = ExternalTxt.create("https://raw.githubusercontent.com/ObscuriaLithium/Minecraft/main/patreon/runestone.txt");

    public static void reload() {
        ObscuriaCollection.upload();
    }

    public static void upload() {
        ABOUT.upload();
        MODS.upload();
        RUNESTONES.upload();
    }

    public static boolean isLoaded() {
        return ABOUT.isUploaded() && RUNESTONES.isUploaded();
    }

    public static boolean isRunestone(Player player) {
        return RUNESTONES.isUploaded() && RUNESTONES.get().contains(player.m_7755_().getString());
    }

    public static boolean isRunestone() {
        return RUNESTONES.isUploaded() && RUNESTONES.get().contains(Minecraft.m_91087_().m_91094_().m_92548_().getName());
    }

    public static @Unmodifiable List<Mod> getCollectionMods() {
        return List.copyOf(COLLECTION_MODS);
    }

    @Nonnull
    public static List<Mod> getSortedMods() {
        ArrayList<Mod> sorted = new ArrayList<Mod>();
        List<Mod> all = ObscuriaCollection.getCollectionMods();
        all.forEach(mod2 -> {
            if (mod2.isInstalled()) {
                sorted.add((Mod)mod2);
            }
        });
        all.forEach(mod2 -> {
            if (!mod2.isInstalled()) {
                sorted.add((Mod)mod2);
            }
        });
        return sorted;
    }

    public static @Unmodifiable List<String> getDescription() {
        return List.of(ExceptionFilter.getNoNull(new String[0], () -> TextUtils.format(ABOUT.get().get("description").getAsString()).split(" > ")));
    }

    public static @Unmodifiable List<String> getDiscord() {
        return List.of(ExceptionFilter.getNoNull(new String[0], () -> TextUtils.format(ABOUT.get().get("discord").getAsString()).split(" > ")));
    }

    public static @Unmodifiable List<String> getGitHub() {
        return List.of(ExceptionFilter.getNoNull(new String[0], () -> TextUtils.format(ABOUT.get().get("github").getAsString()).split(" > ")));
    }

    public static @Unmodifiable List<String> getPatreon() {
        return List.of(ExceptionFilter.getNoNull(new String[0], () -> TextUtils.format(ABOUT.get().get("patreon").getAsString()).split(" > ")));
    }

    public static final class Mod {
        private final List<Mod> ADDONS = new ArrayList<Mod>();
        private final String MODID;
        @Nullable
        private JsonObject INFO;
        @Nullable
        private ExternalTexture COVER;
        @Nullable
        private ExternalTexture ICON;
        @Nullable
        private BiFunction<Minecraft, Screen, Screen> CONFIG;
        @Nullable
        private IModInfo FORGE_INFO;
        private boolean INSTALLED;
        private boolean ADDON;

        private Mod(String modID) {
            this.MODID = modID;
        }

        @Nonnull
        @Contract(value="_ -> new")
        private static Mod load(String modID) {
            Mod mod2 = new Mod(modID);
            ExternalFile.create(ObscuriaCollection.GITHUB + modID + "/info.json", true, file -> {
                mod2.INFO = ExceptionFilter.get(null, file::get);
                ExceptionFilter.of(() -> {
                    for (Map.Entry entry : file.get().getAsJsonObject("addons").entrySet()) {
                        String addonID = (String)entry.getKey();
                        Mod addon = new Mod(addonID);
                        addon.INFO = ((JsonElement)entry.getValue()).getAsJsonObject();
                        addon.ICON = ExternalTexture.create(new ResourceLocation("obscure_api", "generated"), addonID + "_icon.png", ObscuriaCollection.GITHUB + modID + "/icons/" + addonID + ".png").upload();
                        addon.CONFIG = ModList.get().getModContainerById(addonID).flatMap(mc -> mc.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).map(ConfigScreenHandler.ConfigScreenFactory::screenFunction)).orElse(null);
                        addon.FORGE_INFO = ExceptionFilter.get(null, () -> ModList.get().getModContainerById(addonID).isPresent() ? ((ModContainer)ModList.get().getModContainerById(addonID).get()).getModInfo() : null);
                        addon.INSTALLED = ModList.get().isLoaded(addonID);
                        addon.ADDON = true;
                        mod2.ADDONS.add(addon);
                    }
                });
            });
            mod2.COVER = ExternalTexture.create(new ResourceLocation("obscure_api", "generated"), modID + "_cover.png", ObscuriaCollection.GITHUB + modID + "/cover.png").upload();
            mod2.ICON = ExternalTexture.create(new ResourceLocation("obscure_api", "generated"), modID + "_icon.png", ObscuriaCollection.GITHUB + modID + "/icons/base.png").upload();
            mod2.CONFIG = ModList.get().getModContainerById(modID).flatMap(mc -> mc.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).map(ConfigScreenHandler.ConfigScreenFactory::screenFunction)).orElse(null);
            mod2.FORGE_INFO = ExceptionFilter.get(null, () -> ModList.get().getModContainerById(modID).isPresent() ? ((ModContainer)ModList.get().getModContainerById(modID).get()).getModInfo() : null);
            mod2.INSTALLED = ModList.get().isLoaded(modID);
            mod2.ADDON = false;
            return mod2;
        }

        public String getId() {
            return this.MODID;
        }

        public @Unmodifiable List<Mod> getAddons() {
            return List.copyOf(this.ADDONS);
        }

        public boolean isInstalled() {
            return this.INSTALLED;
        }

        public boolean isAddon() {
            return this.ADDON;
        }

        public boolean isLoaded() {
            return this.INFO != null;
        }

        public ResourceLocation getCover() {
            if (this.COVER == null) {
                return new ResourceLocation("null");
            }
            return this.COVER.get();
        }

        public ResourceLocation getIcon() {
            return this.ICON == null ? new ResourceLocation("null") : this.ICON.get();
        }

        public String getName() {
            return ExceptionFilter.getNoNull("...", () -> this.INFO == null ? null : this.INFO.get("name").getAsString());
        }

        public String getLink() {
            return ExceptionFilter.getNoNull("...", () -> this.INFO == null ? null : this.INFO.get("link").getAsString());
        }

        public List<String> getDescription() {
            return List.of(ExceptionFilter.getNoNull(new String[0], () -> this.INFO == null ? null : TextUtils.format(this.INFO.get("description").getAsString()).split(" > ")));
        }

        public boolean isOutdated() {
            return this.FORGE_INFO != null && VersionChecker.getResult((IModInfo)this.FORGE_INFO).status().shouldDraw();
        }

        public boolean hasConfig() {
            return this.CONFIG != null;
        }

        public void openConfig(Screen parent) {
            if (this.CONFIG != null) {
                Screen screen;
                Minecraft minecraft = Minecraft.m_91087_();
                Minecraft minecraft2 = Minecraft.m_91087_();
                if (this.MODID.equals("obscure_api") && parent instanceof ObscuriaCollectionScreen) {
                    ObscuriaCollectionScreen screen2 = (ObscuriaCollectionScreen)parent;
                    screen = screen2.getParent();
                } else {
                    screen = parent;
                }
                minecraft.m_91152_(this.CONFIG.apply(minecraft2, screen));
            }
        }
    }
}

