/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi;

import com.obscuria.obscureapi.api.HandsRenderManager;
import com.obscuria.obscureapi.api.HeartsRenderManager;
import com.obscuria.obscureapi.api.client.DynamicSound;
import com.obscuria.obscureapi.api.hekate.Animation;
import com.obscuria.obscureapi.api.hekate.IAnimated;
import com.obscuria.obscureapi.client.TooltipBuilder;
import com.obscuria.obscureapi.client.renderer.PatreonLayer;
import com.obscuria.obscureapi.client.screen.SettingsScreen;
import com.obscuria.obscureapi.event.ObscureAPIHooks;
import com.obscuria.obscureapi.network.ObscuriaCollection;
import com.obscuria.obscureapi.util.ItemUtils;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Contract;

@OnlyIn(value=Dist.CLIENT)
public final class ObscureAPIClient {
    @Nonnull
    @Contract(pure=true)
    public static Supplier<ConfigScreenHandler.ConfigScreenFactory> getConfigScreen() {
        return () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new SettingsScreen((Screen)screen));
    }

    public static void playLocalDynamicSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new DynamicSound(entity, sound, source, volume, pitch));
    }

    public static void playLocalDynamicSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, Predicate<Entity> condition, boolean loop) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new DynamicSound(entity, sound, source, volume, pitch, condition, loop));
    }

    public static void playAnimation(int id, byte animation, int tick, int duration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(id);
        if (entity instanceof IAnimated) {
            IAnimated IAnimated2 = (IAnimated)entity;
            IAnimated2.getAnimation(animation).ifPresent(anim -> anim.localPlay(tick, duration));
        }
    }

    public static void stopAnimation(int id, byte animation) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(id);
        if (entity instanceof IAnimated) {
            IAnimated IAnimated2 = (IAnimated)entity;
            IAnimated2.getAnimation(animation).ifPresent(Animation::localStop);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
            HeartsRenderManager.onClientTick(event);
        }

        @SubscribeEvent
        public static void onRenderHand(RenderHandEvent event) {
            HandsRenderManager.onRenderHand(event);
        }
    }

    @Mod.EventBusSubscriber(modid="obscure_api", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ObscureAPIHooks.registerHeartsEvent();
            ObscureAPIHooks.registerBossBarsEvent();
            ObscureAPIHooks.registerHandsEvent();
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, TooltipBuilder::buildTooltip);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, TooltipBuilder::buildComponents);
            ItemUtils.addLore("obscure_api:vial_of_knowledge");
            ItemUtils.addLore("obscure_api:obscure_book");
            ObscuriaCollection.upload();
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(@Nonnull EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(PatreonLayer.Model.LAYER_LOCATION, PatreonLayer.Model::createBodyLayer);
        }

        @SubscribeEvent
        public static void addLayers(@Nonnull EntityRenderersEvent.AddLayers event) {
            event.getSkins().forEach(skin -> {
                LivingEntityRenderer renderer = event.getSkin(skin);
                if (renderer != null) {
                    renderer.m_115326_((RenderLayer)new PatreonLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer, event.getEntityModels()));
                }
            });
        }
    }
}

