/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ic2;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerConstructor;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.MultiWireBase;
import com.tom.morewires.MultiWireTypeDefinition;
import com.tom.morewires.WireTypeDefinition;
import com.tom.morewires.compat.ic2.IC2ConnectorBlock;
import com.tom.morewires.compat.ic2.IC2ConnectorBlockEntity;
import com.tom.morewires.compat.ic2.IC2EnergyTransferHandler;
import ic2.core.block.cables.CableBlock;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class IC2WireDefinition
extends MultiWireTypeDefinition<IC2ConnectorBlockEntity> {
    public static RegistryObject<Item> ENERGY_ALLOY;
    public static RegistryObject<Item> UNCOMPRESSED_INSULATION;
    public static RegistryObject<Item> COMPRESSED_INSULATION;
    private final int maxPower;
    private final int tier;

    public static IC2WireDefinition ulv() {
        return new IC2WireDefinition("ulv", "ULV", 8, 0);
    }

    public static IC2WireDefinition lv() {
        return new IC2WireDefinition("lv", "LV", 32, 1);
    }

    public static IC2WireDefinition mv() {
        return new IC2WireDefinition("mv", "MV", 128, 2);
    }

    public static IC2WireDefinition hv() {
        return new IC2WireDefinition("hv", "HV", 512, 3);
    }

    public static IC2WireDefinition ev() {
        return new IC2WireDefinition("ev", "EV", 2048, 4);
    }

    public static IC2WireDefinition iv() {
        return new IC2WireDefinition("iv", "IV", 8192, 5);
    }

    public static IC2WireDefinition luv() {
        return new IC2WireDefinition("luv", "LuV", 32768, 6){

            @Override
            public void init() {
                super.init();
                ENERGY_ALLOY = MoreImmersiveWires.materialItem("ic2_energy_alloy");
                UNCOMPRESSED_INSULATION = MoreImmersiveWires.materialItem("ic2_uncompressed_insulation");
                COMPRESSED_INSULATION = MoreImmersiveWires.materialItem("ic2_compressed_insulation");
            }
        };
    }

    public IC2WireDefinition(String name, String localized, int maxPower, int tier) {
        super("ic2", name, localized);
        this.maxPower = maxPower;
        this.tier = tier;
    }

    @Override
    protected ILocalHandlerConstructor createLocalHandler() {
        return IC2EnergyTransferHandler::new;
    }

    @Override
    public IC2ConnectorBlockEntity createBE(BlockPos pos, BlockState state) {
        return new IC2ConnectorBlockEntity(pos, state, this.maxPower, this.tier){

            public BlockEntityType<?> createType() {
                return (BlockEntityType)IC2WireDefinition.this.CONNECTOR_ENTITY.get();
            }

            public boolean canConnectCable(WireType arg0, ConnectionPoint arg1, Vec3i arg2) {
                return IC2WireDefinition.this.isMatchingWireType(arg0);
            }

            @Override
            ResourceLocation getNetId() {
                return IC2WireDefinition.this.NET_ID;
            }
        };
    }

    @Override
    public Block makeBlock(RegistryObject<BlockEntityType<IC2ConnectorBlockEntity>> type) {
        return new IC2ConnectorBlock(type, this::isCable);
    }

    @Override
    public boolean isCable(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof CableBlock;
    }

    @Override
    protected void wires(Function<String, MultiWireTypeDefinition.WireTypeSettings> create) {
        for (Types t : Types.values()) {
            if (t.max < this.maxPower) continue;
            MultiWireTypeDefinition.WireTypeSettings wts = create.apply(t.name().toLowerCase(Locale.ROOT));
            if (t.settings != null) {
                wts.linked(t.settings);
            } else {
                t.settings = wts.multiwire();
                wts.color(t.color).localized(t.localized);
                if (t.thick) {
                    wts.thick();
                }
            }
            if (t.maxIns >= this.maxPower) {
                wts.setFactory(w -> new Normal((MultiWireTypeDefinition.WireTypeSettings)w, t.max, t.loss / (double)this.maxPower));
                continue;
            }
            wts.setFactory(w -> new Shocking((MultiWireTypeDefinition.WireTypeSettings)w, t.max, t.loss / (double)this.maxPower, t.dmgRange));
        }
    }

    @Override
    public void addTranslations(BiConsumer<String, String> addTranslation) {
        addTranslation.accept("tooltip.more_immersive_wires.network_type." + this.name, this.localized);
    }

    @Override
    public boolean isTallConnector() {
        return this.maxPower >= 512;
    }

    @Override
    public boolean isExTallRelay() {
        return this.maxPower >= 512;
    }

    @Override
    public boolean datagenConnectorBlock() {
        return false;
    }

    public static enum Types {
        TIN(8, 0x999999, "Tin Cable", 0.025),
        COPPER(32, 8, 10773295, "Copper Cable", 0.3),
        INS_COPPER(32, 0x222222, "Insulated Copper Cable", 0.2),
        GOLD(128, 8, 16448583, "Gold Cable", 0.5),
        INS1_GOLD(128, 32, 0x777822, "1x Insulated Gold Cable", (double)0.45f),
        INS2_GOLD(128, 0x222222, "2x Insulated Gold Cable", (double)0.4f),
        BRONZE(128, 8, 12874799, "Bronze Cable", (double)0.7f),
        INS1_BRONZE(128, 32, 6962969, "1x Insulated Bronze Cable", (double)0.65f),
        INS2_BRONZE(128, 0x222222, "2x Insulated Bronze Cable", (double)0.6f),
        GLASS_FIBRE(512, 0x9999AA, "Glass Fibre Cable", 0.025),
        IRON(2048, 8, 7437445, "Iron Cable", 1.0),
        INS1_IRON(2048, 128, 4738901, "1x Insulated Iron Cable", 0.95),
        INS2_IRON(2048, 512, 3159353, "2x Insulated Iron", 0.9),
        INS3_IRON(2048, 2048, 0x222222, true, "4x Insulated Iron", 0.8),
        AL(8192, 8, 0xB7BBB2, "Alunimum Cable", 1.2),
        INS1_AL(8192, 128, 8685440, "1x Insulated Alunimum Cable", 1.15),
        INS2_AL(8192, 512, 6645602, "2x Insulated Alunimum Cable", 1.1),
        INS3_AL(8192, 2048, 4540227, true, "4x Insulated Alunimum Cable", 1.05),
        INS4_AL(8192, 8192, 0x222222, true, "8x Insulated Alunimum Cable", 1.0),
        SUPER(8192, 8192, 0x999922, true, "Superconducting Cable", 0.001),
        PLASMA(32768, 32768, 0x111111, true, "Plasma Cable", 1.2);

        private final int max;
        private final int maxIns;
        private final int color;
        private final int dmgRange;
        private final String localized;
        private MultiWireTypeDefinition.WireTypeSettings settings;
        private final boolean thick;
        private final double loss;

        private Types(int max, int color, String localized, double loss) {
            this(max, max, color, localized, loss);
        }

        private Types(int max, int maxIns, int color, String localized, double loss) {
            this(max, maxIns, color, false, localized, loss);
        }

        private Types(int max, int maxIns, int color, boolean thick, String localized, double loss) {
            this.max = max;
            this.maxIns = maxIns;
            this.color = color;
            this.thick = thick;
            this.loss = loss;
            this.localized = localized;
            this.dmgRange = Mth.m_14173_((int)max);
        }

        public WireTypeDefinition.WireInfo getInfo() {
            return this.settings;
        }
    }

    private static class Shocking
    extends Normal
    implements WireDamageHandler.IShockingWire {
        private final IElectricEquipment.ElectricSource eSource;
        private final int dmg;

        public Shocking(MultiWireTypeDefinition.WireTypeSettings wireTypeSettings, int max, double loss, int dmg) {
            super(wireTypeSettings, max, loss);
            this.eSource = new IElectricEquipment.ElectricSource(0.15f * (float)dmg);
            this.dmg = dmg;
        }

        public double getDamageRadius() {
            return 0.1 * (double)this.dmg;
        }

        public float getDamageAmount(Entity e, Connection c, int energy) {
            return this.dmg;
        }

        public IElectricEquipment.ElectricSource getElectricSource() {
            return this.eSource;
        }
    }

    private static class Normal
    extends MultiWireBase
    implements EnergyTransferHandler.IEnergyWire {
        private double loss;
        private int max;

        public Normal(MultiWireTypeDefinition.WireTypeSettings wireTypeSettings, int max, double loss) {
            super(wireTypeSettings);
            this.loss = loss;
            this.max = max;
        }

        public double getBasicLossRate(Connection c) {
            return this.loss * c.getLength() / 4.0;
        }

        public double getLossRate(Connection arg0, int arg1) {
            return 0.0;
        }

        public int getTransferRate() {
            return this.max;
        }

        public boolean shouldBurn(Connection c, double power) {
            return false;
        }
    }
}

