/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ic2;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.api.wires.utils.IElectricDamageSource;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class IC2EnergyTransferHandler
extends EnergyTransferHandler
implements ICollisionHandler {
    private static final double KNOCKBACK_PER_DAMAGE = 10.0;

    public IC2EnergyTransferHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    public void onCollided(LivingEntity e, BlockPos pos, WireCollisionData.CollisionInfo info) {
        boolean collides;
        WireType wType = info.connection().type;
        if (!(wType instanceof WireDamageHandler.IShockingWire)) {
            return;
        }
        WireDamageHandler.IShockingWire shockWire = (WireDamageHandler.IShockingWire)wType;
        double extra = shockWire.getDamageRadius();
        AABB eAabb = e.m_20191_();
        AABB includingExtra = eAabb.m_82400_(extra).m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        boolean bl = collides = includingExtra.m_82390_(info.intersectA()) || includingExtra.m_82390_(info.intersectB());
        if (!collides && includingExtra.m_82371_(info.intersectA(), info.intersectB()).isEmpty()) {
            return;
        }
        ConnectionPoint target = info.connection().getEndA();
        List<SourceData> available = this.getAvailableEnergy(this, target);
        if (available.isEmpty()) {
            return;
        }
        int totalAvailable = 0;
        for (SourceData source : available) {
            totalAvailable = (int)((double)totalAvailable + (double)source.amountAvailable * (1.0 - source.pathToSource.loss));
        }
        totalAvailable = Math.min(totalAvailable, shockWire.getTransferRate());
        float maxPossibleDamage = shockWire.getDamageAmount((Entity)e, info.connection(), totalAvailable);
        if (maxPossibleDamage <= 0.0f) {
            return;
        }
        IElectricDamageSource dmg = (IElectricDamageSource)((BiFunction)WireDamageHandler.GET_WIRE_DAMAGE.getValue()).apply(Float.valueOf(maxPossibleDamage), shockWire.getElectricSource());
        if (!dmg.apply((Entity)e)) {
            return;
        }
        float actualDamage = dmg.getDamage();
        Vec3 v = e.m_20154_();
        ApiUtils.knockbackNoSource((LivingEntity)e, (double)((double)actualDamage / 10.0), (double)v.f_82479_, (double)v.f_82481_);
        double factor = actualDamage / maxPossibleDamage;
        Object2DoubleMap transferred = this.getTransferredNextTick();
        for (SourceData source : available) {
            double energyFromSource = (double)source.amountAvailable * factor;
            source.source.extractEnergy(Mth.m_14165_((double)energyFromSource));
            for (Connection c : source.pathToSource.conns) {
                transferred.mergeDouble((Object)c, energyFromSource, Double::sum);
            }
        }
    }

    private List<SourceData> getAvailableEnergy(EnergyTransferHandler energyHandler, ConnectionPoint target) {
        ArrayList<SourceData> ret = new ArrayList<SourceData>();
        Map paths = null;
        for (Map.Entry c : energyHandler.getSources().entrySet()) {
            EnergyTransferHandler.Path path;
            int energy = ((EnergyTransferHandler.EnergyConnector)c.getValue()).getAvailableEnergy();
            if (energy <= 0) continue;
            if (paths == null) {
                paths = energyHandler.getPathsFromSource(target);
            }
            if ((path = (EnergyTransferHandler.Path)paths.get(c.getKey())) == null) continue;
            ret.add(new SourceData(energy, path, (EnergyTransferHandler.EnergyConnector)c.getValue()));
        }
        return ret;
    }

    private record SourceData(int amountAvailable, EnergyTransferHandler.Path pathToSource, EnergyTransferHandler.EnergyConnector source) {
    }
}

