/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ic2;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.block.OnCableConnectorBlock;
import com.tom.morewires.compat.ic2.IC2ConnectorBlock;
import com.tom.morewires.compat.ic2.IC2EnergyTransferHandler;
import com.tom.morewires.tile.IOnCable;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.tiles.readers.IEUStorage;
import ic2.core.block.base.tiles.BaseTileEntity;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.energy.EnergyStorage;

public abstract class IC2ConnectorBlockEntity
extends BaseTileEntity
implements IImmersiveConnectable,
IOnCable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IDirectionalBE,
EnergyTransferHandler.EnergyConnector,
IEServerTickableBE,
IMultiEnergySource,
IEUStorage,
IEnergySink,
IEBlockInterfaces.IScrewdriverInteraction {
    protected GlobalWireNetwork globalNet;
    private final int cap;
    private final int tier;
    private final MutableEnergyStorage storageToNet;
    private final MutableEnergyStorage storageToMachine;
    public int currentTickToNet = 0;
    public boolean addedToEnergyNet = false;
    private int lastIn = 1;
    private boolean isUnloaded = false;

    protected IC2ConnectorBlockEntity(BlockPos pos, BlockState state, int cap, int tier) {
        super(pos, state);
        this.cap = cap;
        this.tier = tier;
        this.storageToMachine = new MutableEnergyStorage(cap, cap, cap);
        this.storageToNet = new MutableEnergyStorage(cap, cap, cap);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag toNet = new CompoundTag();
        EnergyHelper.serializeTo((EnergyStorage)this.storageToNet, (CompoundTag)toNet);
        nbt.m_128365_("toNet", (Tag)toNet);
        CompoundTag toMachine = new CompoundTag();
        EnergyHelper.serializeTo((EnergyStorage)this.storageToMachine, (CompoundTag)toMachine);
        nbt.m_128365_("toMachine", (Tag)toMachine);
        nbt.m_128405_("lastPacket", this.lastIn);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag toMachine = nbt.m_128469_("toMachine");
        EnergyHelper.deserializeFrom((EnergyStorage)this.storageToMachine, (CompoundTag)toMachine);
        CompoundTag toNet = nbt.m_128469_("toNet");
        EnergyHelper.deserializeFrom((EnergyStorage)this.storageToNet, (CompoundTag)toNet);
        this.lastIn = nbt.m_128451_("lastPacket");
    }

    public void tickServer() {
        this.currentTickToNet = 0;
    }

    public void setFacing(Direction facing) {
        super.setFacing(facing);
        BlockState oldState = this.m_58900_();
        BlockState newState = (BlockState)oldState.m_61124_((Property)ConnectorBlock.DEFAULT_FACING_PROP, (Comparable)facing);
        this.setState(newState);
    }

    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)ConnectorBlock.DEFAULT_FACING_PROP)) {
            return (Direction)state.m_61143_((Property)ConnectorBlock.DEFAULT_FACING_PROP);
        }
        return Direction.NORTH;
    }

    public boolean isSink(ConnectionPoint arg0) {
        return this.isOutput();
    }

    public boolean isSource(ConnectionPoint arg0) {
        return !this.isOutput();
    }

    public void consumeEnergy(int var1) {
        this.storageToMachine.extractEnergy(var1, false);
    }

    public int getMaxEnergyOutput() {
        return this.cap;
    }

    public int getProvidedEnergy() {
        return this.isOutput() ? this.storageToMachine.getEnergyStored() : 0;
    }

    public int getSourceTier() {
        return this.tier;
    }

    public boolean canEmitEnergy(IEnergyAcceptor var1, Direction var2) {
        return this.isOutput() && this.getFacing() == var2;
    }

    public int getStoredEU() {
        return this.storageToMachine.getEnergyStored();
    }

    public int getMaxEU() {
        return this.cap;
    }

    public int getTier() {
        return this.tier;
    }

    public int getPacketCount() {
        return 1;
    }

    public boolean hasMultiplePackets() {
        return false;
    }

    public boolean canConnect() {
        return true;
    }

    public void connectCable(WireType var1, ConnectionPoint var2, IImmersiveConnectable var3, ConnectionPoint var4) {
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    public void removeCable(Connection var1, ConnectionPoint var2) {
        this.m_6596_();
    }

    public boolean isOnCable() {
        return (Boolean)this.m_58900_().m_61143_((Property)OnCableConnectorBlock.ON_CABLE);
    }

    public float getLength() {
        return this.isOnCable() ? 0.25f : 0.5625f;
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().m_122424_();
        double lengthFromHalf = (double)this.getLength() - type.getRenderDiameter() / 2.0 - 0.5;
        return new Vec3(0.5 + lengthFromHalf * (double)side.m_122429_(), 0.5 + lengthFromHalf * (double)side.m_122430_(), 0.5 + lengthFromHalf * (double)side.m_122431_());
    }

    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds((Direction)this.getFacing(), (float)this.getLength());
    }

    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.getPosition(), 0));
    }

    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.getPosition();
    }

    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return new ConnectionPoint(this.getPosition(), 0);
    }

    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnergyNet) {
            this.addedToEnergyNet = true;
            EnergyNet.INSTANCE.addTile((IEnergyTile)this);
        }
    }

    public void onUnloaded(boolean chunk) {
        if (this.isSimulating() && this.addedToEnergyNet) {
            this.addedToEnergyNet = false;
            EnergyNet.INSTANCE.removeTile((IEnergyTile)this);
        }
        super.onUnloaded(chunk);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.f_58857_);
        this.isUnloaded = false;
    }

    public void m_142339_(Level worldIn) {
        super.m_142339_(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.f_58857_, (IImmersiveConnectable)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
    }

    public int getRequestedEnergy() {
        if (this.isOutput()) {
            return this.storageToMachine.getEnergyStored() > 0 ? 0 : this.storageToMachine.getMaxEnergyStored();
        }
        return this.cap - this.storageToNet.getEnergyStored();
    }

    public int getSinkTier() {
        return this.tier;
    }

    public int acceptEnergy(Direction var1, int amount, int voltage) {
        int maxReceive = Mth.m_14143_((float)Math.min(this.cap - this.currentTickToNet, amount));
        if (maxReceive <= 0) {
            return amount;
        }
        int accepted = Math.min(this.cap, maxReceive);
        accepted = Math.min(this.cap - this.storageToNet.getEnergyStored(), accepted);
        if (accepted <= 0) {
            return amount;
        }
        this.storageToNet.modifyEnergyStored(accepted);
        this.currentTickToNet += accepted;
        this.lastIn = voltage;
        this.m_6596_();
        return amount - accepted;
    }

    public boolean canAcceptEnergy(IEnergyEmitter var1, Direction var2) {
        return !this.isOutput() && this.getFacing() == var2;
    }

    public boolean isOutput() {
        return (Boolean)this.m_58900_().m_61143_((Property)IC2ConnectorBlock.OUTPUT);
    }

    public InteractionResult screwdriverUseSide(Direction arg0, Player arg1, InteractionHand arg2, Vec3 arg3) {
        if (!this.f_58857_.f_46443_) {
            this.setState((BlockState)this.m_58900_().m_61124_((Property)IC2ConnectorBlock.OUTPUT, (Comparable)Boolean.valueOf(!this.isOutput())));
            EnergyNet.INSTANCE.updateTile((IEnergyTile)this);
            ((IC2EnergyTransferHandler)this.globalNet.getLocalNet(this.f_58858_).getHandler(this.getNetId(), IC2EnergyTransferHandler.class)).onConnectorLoaded(new ConnectionPoint(this.getPosition(), 0), this);
        }
        return InteractionResult.SUCCESS;
    }

    public int getAvailableEnergy() {
        return Math.min(this.lastIn, this.storageToNet.getEnergyStored());
    }

    public void insertEnergy(int amount) {
        this.storageToMachine.receiveEnergy(amount, false);
    }

    public void extractEnergy(int amount) {
        this.storageToNet.extractEnergy(amount, false);
    }

    abstract ResourceLocation getNetId();

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)this.getNetId());
    }
}

