/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerConstructor;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.WireTypeDefinition;
import com.tom.morewires.block.OnCableConnectorBlock;
import com.tom.morewires.block.RelayBlock;
import com.tom.morewires.item.ConnectorItemBlock;
import com.tom.morewires.item.WireCoilItem;
import com.tom.morewires.tile.RelayBlockEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public abstract class SimpleWireTypeDefinition<T extends BlockEntity>
implements WireTypeDefinition<T>,
WireTypeDefinition.WireInfo,
WireTypeDefinition.ConnectorInfo,
WireTypeDefinition.RelayInfo {
    public final String name;
    public final String localized;
    public final ResourceLocation NET_ID;
    public final int color;
    public WireType wireType;
    public RegistryObject<BlockEntityType<RelayBlockEntity>> RELAY_ENTITY;
    public RegistryObject<Block> RELAY;
    public RegistryObject<Item> COIL;
    public RegistryObject<Block> CONNECTOR;
    public RegistryObject<BlockEntityType<T>> CONNECTOR_ENTITY;
    private ForgeConfigSpec.IntValue lengthCfg;
    private String modid;

    public SimpleWireTypeDefinition(String name, String localized, int color) {
        this.name = name;
        this.localized = localized;
        this.color = color;
        this.NET_ID = new ResourceLocation("more_immersive_wires", name + "_network");
    }

    @Override
    public void init() {
        this.RELAY = MoreImmersiveWires.blockWithItem(this.name + "_relay", () -> new RelayBlock<RelayBlockEntity>(this.RELAY_ENTITY), b -> new ConnectorItemBlock((Block)b, new Item.Properties().m_41491_(MoreImmersiveWires.MOD_TAB), this, null));
        this.COIL = MoreImmersiveWires.ITEMS.register(this.name + "_coil", () -> new WireCoilItem(this.wireType, this));
        this.RELAY_ENTITY = MoreImmersiveWires.blockEntity(this.name + "_relay.tile", this::createRelayBE, this.RELAY);
        this.CONNECTOR = MoreImmersiveWires.blockWithItem(this.name + "_connector", () -> this.makeBlock(this.CONNECTOR_ENTITY), this::makeItemBlock);
        this.CONNECTOR_ENTITY = MoreImmersiveWires.blockEntity(this.name + "_connector.tile", this::createBE, this.CONNECTOR);
        this.wireType = this.createWire();
        WireApi.registerWireType((WireType)this.wireType);
        LocalNetworkHandler.register((ResourceLocation)this.NET_ID, (ILocalHandlerConstructor)this.createLocalHandler());
    }

    protected WireBase createWire() {
        return new WireBase();
    }

    @Override
    public void setup(MoreImmersiveWires.Wire w) {
        WireApi.registerFeedthroughForWiretype((WireType)this.wireType, (ResourceLocation)new ResourceLocation("more_immersive_wires", "block/connector/connector_" + this.name), (double[])new double[]{0.0, 4.0, 8.0, 12.0}, (double)(this.isTallConnector() ? 0.875 : 0.75), (BlockState)((Block)this.RELAY.get()).m_49966_());
        MoreImmersiveWires.WIRE_TYPES.put((BlockEntityType)this.RELAY_ENTITY.get(), this);
        this.modid = w.modid;
    }

    @Override
    public void config(ForgeConfigSpec.Builder builder) {
        builder.comment(this.localized + " Cable Stettings").translation("config.moreimmersivewires." + this.name + ".settings").push(this.name);
        this.lengthCfg = builder.comment(this.localized + " Cable Max Length").translation("config.moreimmersivewires." + this.name + ".maxlen").defineInRange(this.name + "MaxLen", 16, 4, 256);
        builder.pop();
    }

    protected RelayBlockEntity createRelayBE(BlockPos pos, BlockState state) {
        return new RelayBlockEntity((BlockEntityType<RelayBlockEntity>)((BlockEntityType)this.RELAY_ENTITY.get()), pos, state);
    }

    @Override
    public boolean isMatchingWireType(WireType wt) {
        return wt == this.wireType;
    }

    protected abstract ILocalHandlerConstructor createLocalHandler();

    @Override
    public boolean isTallConnector() {
        return false;
    }

    @Override
    public boolean isThickWire() {
        return this.isTallConnector();
    }

    @Override
    public boolean isTallRelay() {
        return this.isTallConnector();
    }

    @Override
    public boolean isExTallRelay() {
        return false;
    }

    @Override
    public List<? extends WireTypeDefinition.WireInfo> getWireCoils() {
        return Collections.singletonList(this);
    }

    public abstract T createBE(BlockPos var1, BlockState var2);

    public Block makeBlock(RegistryObject<BlockEntityType<T>> type) {
        return new OnCableConnectorBlock<T>(type, this::isCable);
    }

    public abstract boolean isCable(BlockGetter var1, BlockPos var2);

    public Item makeItemBlock(Block block) {
        return new ConnectorItemBlock(block, new Item.Properties().m_41491_(MoreImmersiveWires.MOD_TAB), this, true);
    }

    @Override
    public void appendHoverTextCoil(WireType type, ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        this.appendHoverText(list);
        list.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.mod_id", (Object[])new Object[]{MoreImmersiveWires.MODID_NAME_LOOKUP.getOrDefault(this.modid, this.modid)}).m_130940_(ChatFormatting.BLUE));
    }

    @Override
    public void appendHoverTextConnector(Object id, ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        this.appendHoverText(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.mod_id", (Object[])new Object[]{MoreImmersiveWires.MODID_NAME_LOOKUP.getOrDefault(this.modid, this.modid)}).m_130940_(ChatFormatting.BLUE));
    }

    protected void appendHoverText(List<Component> tooltip) {
    }

    @Override
    public void configReload() {
    }

    @Override
    public String getLocalized() {
        return this.localized;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public RegistryObject<Item> getCoilItem() {
        return this.COIL;
    }

    @Override
    public List<? extends WireTypeDefinition.ConnectorInfo> getConnectors() {
        return Collections.singletonList(this);
    }

    @Override
    public List<? extends WireTypeDefinition.RelayInfo> getRelays() {
        return Collections.singletonList(this);
    }

    @Override
    public RegistryObject<Block> getRelayBlock() {
        return this.RELAY;
    }

    @Override
    public RegistryObject<Block> getConnectorBlock() {
        return this.CONNECTOR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public class WireBase
    extends WireType {
        public ItemStack getWireCoil(Connection var1) {
            return new ItemStack((ItemLike)SimpleWireTypeDefinition.this.COIL.get());
        }

        public String getUniqueName() {
            return "miw:" + SimpleWireTypeDefinition.this.name;
        }

        public double getSlack() {
            return SimpleWireTypeDefinition.this.isThickWire() ? 1.01 : 1.005;
        }

        public double getRenderDiameter() {
            return SimpleWireTypeDefinition.this.isThickWire() ? 0.1 : 0.0625;
        }

        public int getMaxLength() {
            return (Integer)SimpleWireTypeDefinition.this.lengthCfg.get();
        }

        public int getColour(Connection var1) {
            return SimpleWireTypeDefinition.this.color;
        }

        public String getCategory() {
            return "MODDED";
        }

        public Collection<ResourceLocation> getRequestedHandlers() {
            return ImmutableList.of((Object)SimpleWireTypeDefinition.this.NET_ID);
        }
    }
}

