/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires;

import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerConstructor;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.MultiWireBase;
import com.tom.morewires.WireTypeDefinition;
import com.tom.morewires.block.OnCableConnectorBlock;
import com.tom.morewires.block.RelayBlock;
import com.tom.morewires.item.ConnectorItemBlock;
import com.tom.morewires.item.MultiCoilItem;
import com.tom.morewires.tile.RelayBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public abstract class MultiWireTypeDefinition<T extends BlockEntity>
implements WireTypeDefinition<T>,
WireTypeDefinition.ConnectorInfo,
WireTypeDefinition.RelayInfo {
    public final String name;
    public final String pf;
    public final String localized;
    public final ResourceLocation NET_ID;
    public RegistryObject<BlockEntityType<RelayBlockEntity>> RELAY_ENTITY;
    public RegistryObject<Block> RELAY;
    public RegistryObject<Block> CONNECTOR;
    public RegistryObject<BlockEntityType<T>> CONNECTOR_ENTITY;
    private String modid;
    protected List<WireTypeSettings> wires;
    protected Set<WireType> wireTypes;

    public MultiWireTypeDefinition(String pf, String name, String localized) {
        this.name = pf + "_" + name;
        this.pf = pf;
        this.localized = localized;
        this.NET_ID = new ResourceLocation("more_immersive_wires", this.name + "_network");
    }

    @Override
    public void init() {
        this.wires = new ArrayList<WireTypeSettings>();
        this.wires(id -> {
            WireTypeSettings w = new WireTypeSettings(this, this.name + "_" + id, this.pf + "_" + id);
            this.wires.add(w);
            return w;
        });
        this.RELAY = MoreImmersiveWires.blockWithItem(this.name + "_relay", () -> new RelayBlock<RelayBlockEntity>(this.RELAY_ENTITY), b -> new ConnectorItemBlock((Block)b, new Item.Properties().m_41491_(MoreImmersiveWires.MOD_TAB), this, null));
        this.RELAY_ENTITY = MoreImmersiveWires.blockEntity(this.name + "_relay.tile", this::createRelayBE, this.RELAY);
        this.CONNECTOR = MoreImmersiveWires.blockWithItem(this.name + "_connector", () -> this.makeBlock(this.CONNECTOR_ENTITY), this::makeItemBlock);
        this.CONNECTOR_ENTITY = MoreImmersiveWires.blockEntity(this.name + "_connector.tile", this::createBE, this.CONNECTOR);
        this.wires.forEach(w -> {
            w.ITEM = w.linked == null ? MoreImmersiveWires.ITEMS.register(w.itemName + "_coil", () -> new MultiCoilItem((MultiCoilItem.MultiWireInfo)w)) : w.linked.ITEM;
            w.wireType = w.createWire();
            WireApi.registerWireType((WireType)w.wireType);
        });
        LocalNetworkHandler.register((ResourceLocation)this.NET_ID, (ILocalHandlerConstructor)this.createLocalHandler());
        this.wireTypes = this.wires.stream().map(w -> w.wireType).collect(Collectors.toSet());
    }

    protected abstract ILocalHandlerConstructor createLocalHandler();

    public abstract T createBE(BlockPos var1, BlockState var2);

    public Block makeBlock(RegistryObject<BlockEntityType<T>> type) {
        return new OnCableConnectorBlock<T>(type, this::isCable);
    }

    public abstract boolean isCable(BlockGetter var1, BlockPos var2);

    public Item makeItemBlock(Block block) {
        return new ConnectorItemBlock(block, new Item.Properties().m_41491_(MoreImmersiveWires.MOD_TAB), this, true);
    }

    protected RelayBlockEntity createRelayBE(BlockPos pos, BlockState state) {
        return new RelayBlockEntity((BlockEntityType<RelayBlockEntity>)((BlockEntityType)this.RELAY_ENTITY.get()), pos, state);
    }

    protected abstract void wires(Function<String, WireTypeSettings> var1);

    @Override
    public boolean isMatchingWireType(WireType wt) {
        return this.wireTypes.contains(wt);
    }

    @Override
    public void config(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " Cable Stettings").translation("config.moreimmersivewires." + this.name + ".settings").push(this.name);
        this.wires.forEach(w -> {
            w.lengthCfg = w.linked == null ? builder.comment(w.localized + " Cable Max Length").translation("config.moreimmersivewires." + this.name + "." + w.name + ".maxlen").defineInRange(this.name + "_" + w.name + "MaxLen", 16, 4, 256) : w.linked.lengthCfg;
        });
        builder.pop();
    }

    @Override
    public void setup(MoreImmersiveWires.Wire w) {
        MoreImmersiveWires.WIRE_TYPES.put((BlockEntityType)this.RELAY_ENTITY.get(), this);
        this.wires.forEach(wts -> {
            WireApi.registerFeedthroughForWiretype((WireType)wts.wireType, (ResourceLocation)new ResourceLocation("more_immersive_wires", "block/connector/connector_" + this.name), (double[])new double[]{0.0, 4.0, 8.0, 12.0}, (double)(this.isTallRelay() ? 0.875 : 0.75), (BlockState)((Block)this.RELAY.get()).m_49966_());
            if (wts.linked != null) {
                wts.linked.type2linked.put(new MultiCoilItem.MultiWireInfo.ConnectorTypeInfo((Block)this.CONNECTOR.get(), 0), (WireTypeSettings)wts);
                wts.linked.type2linked.put(new MultiCoilItem.MultiWireInfo.ConnectorTypeInfo((Block)this.RELAY.get(), 0), (WireTypeSettings)wts);
            }
        });
        this.modid = w.modid;
    }

    @Override
    public List<? extends WireTypeDefinition.WireInfo> getWireCoils() {
        return this.wires;
    }

    @Override
    public List<? extends WireTypeDefinition.ConnectorInfo> getConnectors() {
        return Collections.singletonList(this);
    }

    @Override
    public List<? extends WireTypeDefinition.RelayInfo> getRelays() {
        return Collections.singletonList(this);
    }

    @Override
    public void appendHoverTextCoil(WireType type, ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        this.appendHoverText(list);
        list.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.mod_id", (Object[])new Object[]{MoreImmersiveWires.MODID_NAME_LOOKUP.getOrDefault(this.modid, this.modid)}).m_130940_(ChatFormatting.BLUE));
    }

    @Override
    public void appendHoverTextConnector(Object id, ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        this.appendHoverText(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.mod_id", (Object[])new Object[]{MoreImmersiveWires.MODID_NAME_LOOKUP.getOrDefault(this.modid, this.modid)}).m_130940_(ChatFormatting.BLUE));
    }

    protected void appendHoverText(List<Component> tooltip) {
    }

    @Override
    public void configReload() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalized() {
        return this.localized;
    }

    @Override
    public boolean isTallConnector() {
        return false;
    }

    @Override
    public boolean isTallRelay() {
        return this.isTallConnector();
    }

    @Override
    public boolean isExTallRelay() {
        return false;
    }

    @Override
    public RegistryObject<Block> getConnectorBlock() {
        return this.CONNECTOR;
    }

    @Override
    public RegistryObject<Block> getRelayBlock() {
        return this.RELAY;
    }

    public static class WireTypeSettings
    implements WireTypeDefinition.WireInfo,
    MultiCoilItem.MultiWireInfo {
        private final MultiWireTypeDefinition<?> impl;
        private RegistryObject<Item> ITEM;
        private boolean thick;
        private int color;
        private String localized;
        private final String name;
        private final String itemName;
        protected ForgeConfigSpec.IntValue lengthCfg;
        private WireType wireType;
        private Supplier<MultiWireBase> create = () -> new MultiWireBase(this);
        private WireTypeSettings linked;
        private boolean multiwire;
        private Map<MultiCoilItem.MultiWireInfo.ConnectorTypeInfo, WireTypeSettings> type2linked;
        private Map<String, WireTypeSettings> id2linked;

        public WireTypeSettings(MultiWireTypeDefinition<?> impl, String name, String itemName) {
            this.impl = impl;
            this.name = name;
            this.itemName = itemName;
        }

        public WireType createWire() {
            return this.create.get();
        }

        public WireTypeSettings setFactory(Function<WireTypeSettings, MultiWireBase> create) {
            this.create = () -> (MultiWireBase)((Object)((Object)create.apply(this)));
            return this;
        }

        public WireTypeSettings localized(String localized) {
            this.localized = localized;
            return this;
        }

        public WireTypeSettings color(int color) {
            this.color = color;
            return this;
        }

        public WireTypeSettings thick() {
            this.thick = true;
            return this;
        }

        public WireTypeSettings multiwire() {
            this.multiwire = true;
            this.type2linked = new HashMap<MultiCoilItem.MultiWireInfo.ConnectorTypeInfo, WireTypeSettings>();
            this.id2linked = new HashMap<String, WireTypeSettings>();
            return this;
        }

        @Override
        public boolean isThickWire() {
            return this.thick;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public String getLocalized() {
            return this.localized;
        }

        @Override
        public RegistryObject<Item> getCoilItem() {
            return this.ITEM;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getItemName() {
            return this.itemName;
        }

        public WireTypeSettings linked(WireTypeSettings wts) {
            if (!wts.multiwire) {
                throw new IllegalArgumentException();
            }
            this.linked = wts;
            this.color = wts.color;
            this.localized = wts.localized;
            this.thick = wts.thick;
            this.create = wts.create;
            wts.id2linked.put(this.impl.name, this);
            return this;
        }

        public MultiWireTypeDefinition<?> impl() {
            return this.impl;
        }

        @Override
        public WireType getWireTypeById(String id) {
            return this.id2linked.getOrDefault((Object)id, (WireTypeSettings)this).wireType;
        }

        @Override
        public void appendHoverTextCoil(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            this.impl.appendHoverText(tooltip);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.mod_id", (Object[])new Object[]{MoreImmersiveWires.MODID_NAME_LOOKUP.getOrDefault(this.impl.modid, this.impl.modid)}).m_130940_(ChatFormatting.BLUE));
        }

        @Override
        public WireType getDefWire() {
            return this.wireType;
        }

        @Override
        public String getTypeId(Level world, MultiCoilItem.MultiWireInfo.ConnectorTypeInfo cpHere) {
            return this.type2linked.getOrDefault((Object)cpHere, (WireTypeSettings)this).impl.name;
        }

        @Override
        public boolean doDatagen() {
            return this.linked == null;
        }
    }
}

