/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.mortuusars.monobank.Monobank;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.renderer.BlockContentsRenderer;
import io.github.mortuusars.monobank.content.monobank.renderer.ItemContentsRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class MonobankRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation DOOR_MODEL_LOCATION = Monobank.resource("block/monobank_door");
    protected BlockContentsRenderer blocksRenderer = new BlockContentsRenderer();
    protected ItemContentsRenderer itemsRenderer = new ItemContentsRenderer();

    public MonobankRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack storedItemStack;
        if (!(blockEntity instanceof MonobankBlockEntity)) {
            return;
        }
        MonobankBlockEntity monobankEntity = (MonobankBlockEntity)((Object)blockEntity);
        float pixel = 0.0625f;
        BlockState blockState = blockEntity.m_58900_();
        float facingYRotation = ((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122424_().m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-facingYRotation));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(pixel * 2.0f), 0.0, 0.0);
        float openness = ((LidBlockEntity)blockEntity).m_6683_(partialTick);
        openness = (double)openness < 0.5 ? 4.0f * openness * openness * openness : (float)(1.0 - Math.pow(-2.0f * openness + 2.0f, 3.0) / 2.0);
        float opennessRotation = openness * 112.5f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(opennessRotation));
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(DOOR_MODEL_LOCATION);
        Minecraft.m_91087_().m_91289_().m_110937_().renderModel(poseStack.m_85850_(), bufferSource.m_6299_(RenderType.m_110451_()), null, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, RenderType.m_110451_());
        poseStack.m_85849_();
        if (openness > 0.0f && !(storedItemStack = monobankEntity.getStoredItemStack()).m_41619_()) {
            this.renderContents(storedItemStack, monobankEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    public void renderContents(ItemStack stack, MonobankBlockEntity monobankEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        boolean renderedAsBlock = Minecraft.m_91087_().m_91291_().m_174264_(stack, monobankEntity.m_58904_(), null, 0).m_7539_();
        float fullness = monobankEntity.getFullness();
        if (renderedAsBlock) {
            this.blocksRenderer.render(stack, fullness, monobankEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            this.itemsRenderer.render(stack, fullness, monobankEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }
}

