/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate.builders;

import com.sammy.minersdelight.repack.registrate.AbstractRegistrate;
import com.sammy.minersdelight.repack.registrate.builders.AbstractBuilder;
import com.sammy.minersdelight.repack.registrate.builders.BuilderCallback;
import com.sammy.minersdelight.repack.registrate.util.OneTimeEventReceiver;
import com.sammy.minersdelight.repack.registrate.util.entry.BlockEntityEntry;
import com.sammy.minersdelight.repack.registrate.util.entry.RegistryEntry;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityBuilder<T extends BlockEntity, P>
extends AbstractBuilder<BlockEntityType<?>, BlockEntityType<T>, P, BlockEntityBuilder<T, P>> {
    private final BlockEntityFactory<T> factory;
    private final Set<NonNullSupplier<? extends Block>> validBlocks = new HashSet<NonNullSupplier<? extends Block>>();
    @Nullable
    private NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>>> renderer;

    public static <T extends BlockEntity, P> BlockEntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityFactory<T> factory) {
        return new BlockEntityBuilder<T, P>(owner, parent, name, callback, factory);
    }

    protected BlockEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityFactory<T> factory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.BLOCK_ENTITY_TYPES);
        this.factory = factory;
    }

    public BlockEntityBuilder<T, P> validBlock(NonNullSupplier<? extends Block> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<T, P> validBlocks(NonNullSupplier<? extends Block> ... blocks) {
        Arrays.stream(blocks).forEach(this::validBlock);
        return this;
    }

    public BlockEntityBuilder<T, P> renderer(NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>>> renderer) {
        if (this.renderer == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<T>>> renderer = this.renderer;
            if (renderer != null) {
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)this.getEntry()), renderer.get()::apply);
            }
        });
    }

    @Override
    protected BlockEntityType<T> createEntry() {
        BlockEntityFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        return BlockEntityType.Builder.m_155273_((pos, state) -> factory.create((BlockEntityType)supplier.get(), pos, state), (Block[])((Block[])this.validBlocks.stream().map(NonNullSupplier::get).toArray(Block[]::new))).m_58966_(null);
    }

    @Override
    protected RegistryEntry<BlockEntityType<T>> createEntryWrapper(RegistryObject<BlockEntityType<T>> delegate) {
        return new BlockEntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntityEntry<T> register() {
        return (BlockEntityEntry)super.register();
    }

    public static interface BlockEntityFactory<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

