/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sammy.minersdelight.repack.registrate.AbstractRegistrate;
import com.sammy.minersdelight.repack.registrate.builders.Builder;
import com.sammy.minersdelight.repack.registrate.builders.BuilderCallback;
import com.sammy.minersdelight.repack.registrate.providers.ProviderType;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateLangProvider;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateTagsProvider;
import com.sammy.minersdelight.repack.registrate.util.entry.LazyRegistryEntry;
import com.sammy.minersdelight.repack.registrate.util.entry.RegistryEntry;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullBiFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.registries.RegistryObject;

public abstract class AbstractBuilder<R, T extends R, P, S extends AbstractBuilder<R, T, P, S>>
implements Builder<R, T, P, S> {
    private final AbstractRegistrate<?> owner;
    private final P parent;
    private final String name;
    private final BuilderCallback callback;
    private final ResourceKey<Registry<R>> registryKey;
    private final Multimap<ProviderType<? extends RegistrateTagsProvider<?>>, TagKey<?>> tagsByType = HashMultimap.create();
    private final LazyRegistryEntry<T> safeSupplier = new LazyRegistryEntry(this);

    @NonnullType
    protected abstract T createEntry();

    @Override
    public RegistryEntry<T> register() {
        return this.callback.accept(this.name, this.registryKey, this, this::createEntry, this::createEntryWrapper);
    }

    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new RegistryEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public NonNullSupplier<T> asSupplier() {
        return this.safeSupplier;
    }

    @SafeVarargs
    public final S tag(ProviderType<? extends RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (!this.tagsByType.containsKey(type)) {
            this.setData(type, (ctx, prov) -> this.tagsByType.get((Object)type).stream().map(t -> t).map(prov::m_206424_).forEach(b -> b.m_126582_(this.asSupplier().get())));
        }
        this.tagsByType.putAll(type, Arrays.asList(tags));
        return (S)this;
    }

    @SafeVarargs
    public final S removeTag(ProviderType<RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (this.tagsByType.containsKey(type)) {
            for (TagKey<R> tag : tags) {
                this.tagsByType.remove(type, tag);
            }
        }
        return (S)this;
    }

    public S lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> t) -> p.getAutomaticName(t, this.getRegistryKey()));
    }

    public S lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> s) -> name);
    }

    private S lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (S)((AbstractBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> prov.add((String)langKeyProvider.apply(ctx.getEntry()), (String)localizedNameProvider.apply((RegistrateLangProvider)prov, ctx::getEntry))));
    }

    public AbstractBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceKey<Registry<R>> registryKey) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryKey = registryKey;
    }

    @Override
    public AbstractRegistrate<?> getOwner() {
        return this.owner;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected BuilderCallback getCallback() {
        return this.callback;
    }

    @Override
    public ResourceKey<Registry<R>> getRegistryKey() {
        return this.registryKey;
    }
}

