/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import java.util.UUID;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.ChestType;
import noobanidus.mods.lootr.block.entities.LootrChestBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.util.Getter;

public class LootrChestBlockRenderer<T extends LootrChestBlockEntity>
extends ChestRenderer<T> {
    private UUID playerId = null;
    public static final Material MATERIAL = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "chest"));
    public static final Material MATERIAL2 = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "chest_opened"));
    public static final Material MATERIAL3 = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "trapped_chest"));
    public static final Material MATERIAL4 = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "trapped_chest_opened"));

    public LootrChestBlockRenderer(BlockEntityRendererProvider.Context p_173607_) {
        super(p_173607_);
    }

    protected Material getMaterial(T tile, ChestType type) {
        boolean trapped;
        boolean bl = trapped = tile.m_58903_() == ModBlockEntities.LOOTR_TRAPPED_CHEST.get();
        if (ConfigManager.isVanillaTextures()) {
            return trapped ? Sheets.f_110745_ : Sheets.f_110751_;
        }
        if (this.playerId == null) {
            Player player = Getter.getPlayer();
            if (player != null) {
                this.playerId = player.m_20148_();
            } else {
                return trapped ? MATERIAL3 : MATERIAL;
            }
        }
        if (((LootrChestBlockEntity)tile).isOpened()) {
            return trapped ? MATERIAL4 : MATERIAL2;
        }
        if (((LootrChestBlockEntity)tile).getOpeners().contains(this.playerId)) {
            return trapped ? MATERIAL4 : MATERIAL2;
        }
        return trapped ? MATERIAL3 : MATERIAL;
    }
}

