/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.pickup;

import com.mojang.blaze3d.vertex.PoseStack;
import com.obscuria.lootjournal.LootJournalConfig;
import com.obscuria.lootjournal.client.pickup.Pickup;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemPickup
extends Pickup {
    protected final ItemStack stack;
    protected int count;
    protected int total;

    public static ItemPickup of(ItemStack stack) {
        return new ItemPickup(stack);
    }

    protected ItemPickup(ItemStack stack) {
        this.stack = stack;
        this.count = stack.m_41613_();
        this.countTotal(this.count);
    }

    @Override
    public boolean merge(Pickup pickup) {
        if (pickup instanceof ItemPickup) {
            ItemPickup other = (ItemPickup)pickup;
            if (this.stack.m_41656_(other.stack) && this.stack.areShareTagsEqual(other.stack)) {
                this.count += other.count;
                this.countTotal(other.count);
                return true;
            }
        }
        return false;
    }

    @Override
    public MutableComponent getName() {
        Object name = this.stack.m_41786_().getString();
        if (((String)name).length() > 24) {
            name = ((String)name).substring(0, 23) + "...";
        }
        if (this.count > 1) {
            name = (String)name + " x" + this.count;
        }
        return Component.m_237113_((String)name).m_130938_(this.stack.m_41791_().getStyleModifier());
    }

    @Override
    public boolean shouldRenderTotal() {
        return (Boolean)LootJournalConfig.total.get() != false && this.total > 1;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public void renderIcon(PoseStack pose, long time) {
        Minecraft.m_91087_().m_91291_().m_115203_(this.stack, -8, -8);
    }

    private void countTotal(int origin) {
        this.total = origin;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        for (ItemStack invStack : Minecraft.m_91087_().f_91074_.m_150109_().f_35974_) {
            this.total += this.searchSameItems(invStack);
        }
    }

    private int searchSameItems(ItemStack stack) {
        ItemStack container;
        CompoundTag compoundTag;
        ListTag listTag;
        ItemStack shulker;
        Tag tag;
        int searched = 0;
        if (this.stack.m_41656_(stack) && this.stack.areShareTagsEqual(stack)) {
            searched += stack.m_41613_();
        }
        if (stack.m_41720_() == Items.f_42265_ && (tag = (shulker = stack.m_41777_()).m_41784_().m_128469_("BlockEntityTag").m_128423_("Items")) instanceof ListTag) {
            listTag = (ListTag)tag;
            for (Tag tagIn : listTag.stream().toList()) {
                if (!(tagIn instanceof CompoundTag)) continue;
                compoundTag = (CompoundTag)tagIn;
                searched += this.searchSameItems(ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        if (stack.m_41777_().m_41784_().m_128441_("Items") && (tag = (container = stack.m_41777_()).m_41784_().m_128423_("Items")) instanceof ListTag) {
            listTag = (ListTag)tag;
            for (Tag tagIn : listTag.stream().toList()) {
                if (!(tagIn instanceof CompoundTag)) continue;
                compoundTag = (CompoundTag)tagIn;
                searched += this.searchSameItems(ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        return searched;
    }
}

