/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client;

import com.obscuria.lootjournal.LootJournalConfig;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class Filtering {
    public static boolean isAllowed(ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (Filtering.itemsWhitelist().contains(itemId)) {
            return true;
        }
        if (((Boolean)LootJournalConfig.blacklistedByDefault.get()).booleanValue()) {
            return false;
        }
        return !Filtering.itemsBlacklist().contains(itemId);
    }

    private static List<ResourceLocation> tabsBlacklist() {
        return Filtering.remap((List)LootJournalConfig.tabsBlacklist.get());
    }

    private static List<ResourceLocation> itemsBlacklist() {
        return Filtering.remap((List)LootJournalConfig.itemsBlacklist.get());
    }

    private static List<ResourceLocation> tabsWhitelist() {
        return Filtering.remap((List)LootJournalConfig.tabsWhitelist.get());
    }

    private static List<ResourceLocation> itemsWhitelist() {
        return Filtering.remap((List)LootJournalConfig.itemsWhitelist.get());
    }

    private static List<ResourceLocation> remap(List<? extends String> list) {
        return list.stream().map(ResourceLocation::new).toList();
    }
}

