/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.pickup;

import com.obscuria.lootjournal.LootJournalConfig;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Pickup {
    private static final float MAX_LIFETIME = ((Integer)LootJournalConfig.Client.lifetime.get()).intValue();
    private static final float MAX_OFFSET = 180.0f;
    public int lifetime;
    public float offset;
    public float offsetLerp;

    public Pickup() {
        this.offsetLerp = this.offset = 180.0f;
    }

    public void tick(List<Pickup> list) {
        ++this.lifetime;
        this.offsetLerp = this.offset;
        this.offset = Math.max(0.0f, Math.min(180.0f, (float)this.lifetime < MAX_LIFETIME * 20.0f ? this.offset - 15.0f : this.offset + 5.0f));
        if ((float)this.lifetime > MAX_LIFETIME * 20.0f + 30.0f) {
            list.remove(this);
        }
    }

    public abstract boolean merge(Pickup var1);

    public abstract void countTotal(int var1);
}

