/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client;

import com.obscuria.lootjournal.client.pickup.ItemStackPickup;
import com.obscuria.lootjournal.client.pickup.Pickup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class PickupHandler {
    private static final List<Pickup> PICKUP_ENTRIES = new ArrayList<Pickup>();

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        List.copyOf(PICKUP_ENTRIES).forEach(pickupEntry -> pickupEntry.tick(PICKUP_ENTRIES));
    }

    public static void addFromPacket(int itemID, int playerID, int amount) {
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_19879_() == playerID && (entity = player.f_19853_.m_6815_(itemID)) instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_().m_41777_();
            stack.m_41764_(amount);
            PickupHandler.addItemStack(stack);
        }
    }

    public static void addItemStack(ItemStack stack) {
        if (!PickupHandler.merge(new ItemStackPickup(stack.m_41777_()))) {
            PICKUP_ENTRIES.add(new ItemStackPickup(stack.m_41777_()));
        }
    }

    public static boolean merge(Pickup pickup) {
        for (Pickup pickupEntry : List.copyOf(PICKUP_ENTRIES)) {
            if (!pickupEntry.merge(pickup)) continue;
            return true;
        }
        return false;
    }

    public static List<Pickup> getList() {
        return List.copyOf(PICKUP_ENTRIES);
    }
}

