/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal;

import com.obscuria.lootjournal.LootJournalMod;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.ChatFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class LootJournalConfig {
    public static void load() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "Obscuria");
        try {
            Files.createDirectory(modConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LootJournalMod.LOGGER.error("Failed to create Obscuria config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.CLIENT_SPEC, "Obscuria/loot-journal-client.toml");
    }

    public static class Client {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec CLIENT_SPEC;
        public static final ForgeConfigSpec.EnumValue<PickupStyle> style;
        public static final ForgeConfigSpec.IntValue lifetime;
        public static final ForgeConfigSpec.IntValue offset;
        public static final ForgeConfigSpec.BooleanValue useCustomColor;
        public static final ForgeConfigSpec.EnumValue<ChatFormatting> customColor;

        static {
            BUILDER.push("PickupNotifier");
            style = BUILDER.worldRestart().defineEnum("Style", (Enum)PickupStyle.COMMON);
            lifetime = BUILDER.worldRestart().defineInRange("Lifetime", 5, 0, 20);
            offset = BUILDER.worldRestart().defineInRange("Offset", 0, 0, 1080);
            useCustomColor = BUILDER.worldRestart().comment("If false, the item's rarity color will be used").define("UseCustomColor", false);
            customColor = BUILDER.worldRestart().defineEnum("CustomColor", (Enum)ChatFormatting.WHITE);
            BUILDER.pop();
            CLIENT_SPEC = BUILDER.build();
        }
    }

    public static enum PickupStyle {
        COMMON,
        WITHOUT_BACKGROUND;

    }
}

