/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class RecastOverlay
extends GuiComponent {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    static final int IMAGE_WIDTH = 54;
    static final int COMPLETION_BAR_WIDTH = 44;
    static final int IMAGE_HEIGHT = 21;
    static final int CONNECTOR_WIDTH = 6;
    static final int ORB_WIDTH = 10;
    static final int ORB_TEXTURE_OFFSET_X = 99;
    static final int ORB_TEXTURE_OFFSET_Y = 5;
    static final int CONNECTOR_TEXTURE_OFFSET_X = 109;
    static final int CONNECTOR_TEXTURE_OFFSET_Y = 8;

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (!ClientMagicData.getRecasts().hasRecastsActive()) {
            return;
        }
        int totalHeightPerBar = 18;
        int screenTopBuffer = 6;
        List<RecastInstance> activeRecasts = ClientMagicData.getRecasts().getActiveRecasts();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Anchor anchor = (Anchor)((Object)ClientConfigs.RECAST_ANCHOR.get());
        for (int castIndex = 0; castIndex < activeRecasts.size(); ++castIndex) {
            RecastInstance recastInstance = activeRecasts.get(castIndex);
            AbstractSpell spell = SpellRegistry.getSpell(recastInstance.getSpellId());
            int total = recastInstance.getTotalRecasts();
            int remaining = recastInstance.getRemainingRecasts();
            int totalWidth = total * 10 + (total - 1) * 6;
            int barX = (int)((float)screenWidth * anchor.m1);
            int barY = (int)((float)screenHeight * anchor.m2);
            if (anchor == Anchor.Center || anchor == Anchor.TopCenter) {
                barX -= totalWidth / 2;
            }
            if (anchor == Anchor.TopCenter) {
                barY += screenTopBuffer;
            }
            barY += ((Integer)ClientConfigs.RECAST_Y_OFFSET.get()).intValue();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((barX += ((Integer)ClientConfigs.RECAST_X_OFFSET.get()).intValue()) - 18), (double)((barY += totalHeightPerBar * castIndex) - 2), 0.0);
            poseStack.m_85841_(0.85f, 0.85f, 0.85f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)spell.getSpellIconResource());
            RecastOverlay.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RecastOverlay.m_93133_((PoseStack)poseStack, (int)-2, (int)-2, (float)116.0f, (float)0.0f, (int)20, (int)20, (int)256, (int)256);
            poseStack.m_85849_();
            for (int i = 0; i < total; ++i) {
                int orbX = barX + 16 * i;
                int connectorX = orbX + 10;
                if (i + 1 < total) {
                    RecastOverlay.m_93133_((PoseStack)poseStack, (int)connectorX, (int)(barY + 3), (float)109.0f, (float)8.0f, (int)6, (int)4, (int)256, (int)256);
                }
                boolean charged = i < remaining;
                RecastOverlay.m_93133_((PoseStack)poseStack, (int)orbX, (int)barY, (float)(99 + (charged ? 0 : 10)), (float)26.0f, (int)10, (int)10, (int)256, (int)256);
                if (charged) {
                    Vector3f color = spell.getSchoolType().getTargetingColor();
                    RenderSystem.m_157429_((float)color.m_122239_(), (float)color.m_122260_(), (float)color.m_122269_(), (float)1.0f);
                    RecastOverlay.m_93133_((PoseStack)poseStack, (int)orbX, (int)barY, (float)(99 + (charged ? 0 : 10)), (float)26.0f, (int)10, (int)10, (int)256, (int)256);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RecastOverlay.m_93133_((PoseStack)poseStack, (int)orbX, (int)barY, (float)99.0f, (float)5.0f, (int)10, (int)10, (int)256, (int)256);
            }
            int textX = barX + 16 * total;
            Font font = gui.m_93082_();
            String string = RecastOverlay.formatTime(recastInstance.getTicksRemaining(), recastInstance.getTicksToLive());
            float f = textX;
            Objects.requireNonNull(gui.m_93082_());
            font.m_92883_(poseStack, string, f, (float)(barY + (10 - 9) / 2), ChatFormatting.WHITE.m_126665_().intValue());
        }
    }

    private static String formatTime(int ticksRemaining, int totalTicks) {
        int totalSeconds = totalTicks / 20;
        int remainingSeconds = ticksRemaining / 20;
        Object time = "";
        if (totalSeconds > 60) {
            time = (String)time + String.format("%s:", remainingSeconds / 60);
            remainingSeconds %= 60;
        }
        if (totalSeconds >= 10) {
            time = (String)time + remainingSeconds / 10;
        }
        time = (String)time + remainingSeconds % 10;
        return (String)time + "s";
    }

    public static enum Anchor {
        Center(0.5f, 0.5f),
        TopCenter(0.5f, 0.0f),
        TopLeft(0.0f, 0.0f),
        TopRight(0.0f, 1.0f),
        BottomLeft(0.0f, 1.0f),
        BottomRight(1.0f, 1.0f);

        final float m1;
        final float m2;

        private Anchor(float mx, float my) {
            this.m1 = mx;
            this.m2 = my;
        }
    }
}

