/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class CastBarOverlay
extends GuiComponent {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    static final int IMAGE_WIDTH = 54;
    static final int COMPLETION_BAR_WIDTH = 44;
    static final int IMAGE_HEIGHT = 21;

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (!ClientMagicData.isCasting() || ClientMagicData.isCasting() && ClientMagicData.getCastType() == CastType.INSTANT) {
            return;
        }
        float castCompletionPercent = ClientMagicData.getCastCompletionPercent();
        String castTimeString = Utils.timeFromTicks((1.0f - castCompletionPercent) * (float)ClientMagicData.getCastDuration(), 1);
        if (ClientMagicData.getCastType() == CastType.CONTINUOUS) {
            castCompletionPercent = 1.0f - castCompletionPercent;
        }
        int barX = screenWidth / 2 - 27;
        int barY = screenHeight / 2 + screenHeight / 8;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        ForgeGui.m_93133_((PoseStack)poseStack, (int)barX, (int)barY, (float)0.0f, (float)42.0f, (int)54, (int)21, (int)256, (int)256);
        gui.m_93228_(poseStack, barX, barY, 0, 63, (int)(44.0f * castCompletionPercent + 5.0f), 21);
        ChatFormatting textColor = ChatFormatting.WHITE;
        Font font = gui.m_93082_();
        int textX = barX + (54 - font.m_92895_(castTimeString)) / 2;
        Objects.requireNonNull(font);
        int textY = barY + 10 - 9 / 2 + 1;
        gui.m_93082_().m_92883_(poseStack, castTimeString, (float)textX, (float)textY, textColor.m_126665_().intValue());
    }
}

