/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class ActiveSpellOverlay
extends GuiComponent {
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        AbstractSpell spell;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (ActiveSpellOverlay.hasRightClickCasting(stack.m_41720_())) {
            spell = ISpellContainer.isSpellContainer(stack) ? ISpellContainer.get(stack).getSpellAtIndex(0).getSpell() : ClientMagicData.getSpellSelectionManager().getSelectedSpellData().getSpell();
        } else {
            stack = player.m_21206_();
            if (ActiveSpellOverlay.hasRightClickCasting(stack.m_41720_())) {
                spell = ISpellContainer.isSpellContainer(stack) ? ISpellContainer.get(stack).getSpellAtIndex(0).getSpell() : ClientMagicData.getSpellSelectionManager().getSelectedSpellData().getSpell();
            } else {
                return;
            }
        }
        if (stack.m_41619_() || spell == SpellRegistry.none()) {
            return;
        }
        int centerX = screenWidth / 2 + 91 + 9;
        int centerY = screenHeight - 23;
        ActiveSpellOverlay.setTranslucentTexture(WIDGETS_LOCATION);
        gui.m_93228_(poseStack, centerX, centerY, 24, 22, 29, 24);
        ActiveSpellOverlay.setOpaqueTexture(spell.getSpellIconResource());
        ForgeGui.m_93133_((PoseStack)poseStack, (int)(centerX + 3), (int)(centerY + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        float f = ClientMagicData.getCooldownPercent(spell);
        if (f > 0.0f && !stack.m_41720_().equals(ItemRegistry.SCROLL.get())) {
            ActiveSpellOverlay.setTranslucentTexture(TEXTURE);
            int pixels = (int)(16.0f * f + 1.0f);
            gui.m_93228_(poseStack, centerX + 3, centerY + 20 - pixels, 47, 87, 16, pixels);
        }
    }

    private static boolean hasRightClickCasting(Item item) {
        return item instanceof Scroll || item instanceof CastingItem;
    }

    private static void setOpaqueTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private static void setTranslucentTexture(ResourceLocation texture) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172649_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }
}

