/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.portal;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class PortalRenderer
extends EntityRenderer<PortalEntity> {
    private static final ResourceLocation TEXTURE = IronsSpellbooks.id("textures/entity/portal.png");
    static int frameCount = 10;
    static int ticksPerFrame = 2;

    public PortalRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PortalEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-entity.m_146908_()));
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_85861_();
        Matrix3f normalMatrix = pose.m_85864_();
        VertexConsumer consumer = bufferSource.m_6299_(CustomerRenderType.m_110494_(PortalRenderer.getTextureLocation()));
        int anim = entity.f_19797_ / ticksPerFrame % 9;
        float uvMin = (float)anim / (float)frameCount;
        float uvMax = (float)(anim + 1) / (float)frameCount;
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, -8.0f, 0.0f, 0.0f, uvMin, 0.0f);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, 8.0f, 0.0f, 0.0f, uvMax, 0.0f);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, 8.0f, 32.0f, 0.0f, uvMax, 1.0f);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, -8.0f, 32.0f, 0.0f, uvMin, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    private static void debugText(String text, float yOffset, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)yOffset, 0.0);
        matrixStackIn.m_85845_(Minecraft.m_91087_().f_91063_.m_109153_().m_90591_());
        matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float f2 = -font.m_92895_(text) / 2;
        font.m_92811_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, true, j, packedLightIn);
        matrixStackIn.m_85849_();
    }

    public static void vertex(Matrix4f pMatrix, Matrix3f pNormals, VertexConsumer pVertexBuilder, float pOffsetX, float pOffsetY, float pOffsetZ, float pTextureX, float pTextureY) {
        pVertexBuilder.m_85982_(pMatrix, pOffsetX, pOffsetY, pOffsetZ).m_6122_(255, 255, 255, 100).m_7421_(pTextureX, pTextureY).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(pNormals, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(PortalEntity entity) {
        return PortalRenderer.getTextureLocation();
    }

    public static ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    public static class CustomerRenderType
    extends RenderType {
        protected static final RenderStateShard.TransparencyStateShard ONE_MINUS = new RenderStateShard.TransparencyStateShard("one_minus", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        });

        public CustomerRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }

        @NotNull
        public static RenderType m_110494_(@NotNull ResourceLocation pLocation) {
            return CustomerRenderType.m_173215_((String)"crumbling", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173074_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(pLocation, false, false)).m_110685_(ONE_MINUS).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false));
        }
    }
}

