/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.devour_jaw;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.devour_jaw.DevourJaw;
import java.util.Objects;
import net.minecraft.client.model.EvokerFangsModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class DevourJawRenderer
extends EntityRenderer<DevourJaw> {
    private final DevourJawModel model;

    public DevourJawRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new DevourJawModel(pContext.m_174023_(ModelLayers.f_171147_));
    }

    public void render(DevourJaw entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (entity.f_19797_ < entity.waitTime) {
            return;
        }
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-entity.m_146908_()));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(1.85f, 1.85f, 1.85f);
        this.model.setupAnim(entity, f, 0.0f, 0.0f, entity.m_146908_(), entity.m_146909_());
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, multiBufferSource, light);
    }

    public ResourceLocation getTextureLocation(DevourJaw pEntity) {
        return IronsSpellbooks.id("textures/entity/devour_jaw.png");
    }

    static class DevourJawModel
    extends EvokerFangsModel<DevourJaw> {
        private final ModelPart root;
        private final ModelPart base;
        private final ModelPart upperJaw;
        private final ModelPart lowerJaw;

        public DevourJawModel(ModelPart pRoot) {
            super(pRoot);
            this.root = pRoot;
            this.base = pRoot.m_171324_("base");
            this.upperJaw = pRoot.m_171324_("upper_jaw");
            this.lowerJaw = pRoot.m_171324_("lower_jaw");
        }

        public void setupAnim(DevourJaw entity, float time, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            Objects.requireNonNull(entity);
            float interval = entity.warmupTime - entity.waitTime;
            float f = Mth.m_14036_((float)((time -= 5.0f) / interval), (float)0.0f, (float)1.0f);
            f = 1.0f - f * f * f * f;
            this.upperJaw.f_104205_ = (float)Math.PI - f * 0.35f * (float)Math.PI;
            this.lowerJaw.f_104205_ = (float)Math.PI + f * 0.35f * (float)Math.PI;
            float f2 = time / interval;
            f2 = 0.5f * Mth.m_14089_((float)(1.5707964f * (f2 - 1.0f))) + 0.5f;
            f2 *= f2;
            this.lowerJaw.f_104201_ = this.upperJaw.f_104201_ = -18.0f * f2 + 16.0f;
            this.base.f_104201_ = this.upperJaw.f_104201_;
        }
    }
}

