/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.network.spell.ClientboundSyncTargetingData;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SacrificeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "sacrifice");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(10).setCooldownSeconds(20.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation(this.getDamage(spellLevel, caster), 2)}), Component.m_237110_((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount(spellLevel, caster)}));
    }

    public SacrificeSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        EntityHitResult entityHit;
        Entity entity2;
        Vec3 end;
        float aimAssist = 0.25f;
        float range = 25.0f;
        Vec3 start = entity.m_146892_();
        HitResult target = Utils.raycastForEntity(entity.f_19853_, (Entity)entity, start, end = entity.m_20154_().m_82541_().m_82490_((double)range).m_82549_(start), true, aimAssist, e -> {
            MagicSummon summon;
            return e instanceof MagicSummon && (summon = (MagicSummon)e).getSummoner() == entity;
        });
        if (target instanceof EntityHitResult && (entity2 = (entityHit = (EntityHitResult)target).m_82443_()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity2;
            playerMagicData.setAdditionalCastData(new CastTargetingData(livingTarget));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Messages.sendToPlayer(new ClientboundSyncTargetingData(livingTarget, this), serverPlayer);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), this.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            return true;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.sacrifice_target_failure").m_130940_(ChatFormatting.RED)));
        }
        return false;
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        CastTargetingData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof CastTargetingData && (targetEntity = (targetData = (CastTargetingData)iCastData).getTarget((ServerLevel)level)) != null) {
            float damage = this.getDamage(spellLevel, entity);
            float explosionRadius = 3.0f;
            MagicManager.spawnParticles(level, ParticleHelper.BLOOD, targetEntity.m_20185_(), targetEntity.m_20186_() + 0.25, targetEntity.m_20189_(), 100, 0.03, 0.4, 0.03, 0.4, true);
            MagicManager.spawnParticles(level, (ParticleOptions)new ShockwaveParticleOptions(((SchoolType)SchoolRegistry.BLOOD.get()).getTargetingColor(), explosionRadius, false), targetEntity.m_20185_(), targetEntity.m_20186_() + (double)0.15f, targetEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0, true);
            List entities = level.m_45933_((Entity)targetEntity, targetEntity.m_20191_().m_82400_((double)explosionRadius));
            for (Entity victim : entities) {
                double distance = victim.m_20238_(targetEntity.m_20182_());
                if (!(distance < (double)(explosionRadius * explosionRadius)) || !Utils.hasLineOfSight(level, targetEntity.m_20191_().m_82399_(), victim.m_20191_().m_82399_(), true)) continue;
                float p = (float)(1.0 - Math.pow(Math.sqrt(distance) / (double)explosionRadius, 3.0));
                DamageSources.applyDamage(victim, damage * p, this.getDamageSource((Entity)targetEntity, (Entity)entity));
            }
            CameraShakeManager.addCameraShake(new CameraShakeData(10, targetEntity.m_20182_(), 20.0f));
            targetEntity.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getCount(int spellLevel, LivingEntity caster) {
        return (int)((float)(4 + spellLevel) * this.getSpellPower(spellLevel, (Entity)caster));
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 1.0f + this.getSpellPower(spellLevel, (Entity)caster);
    }
}

