/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.loot.SpellFilter;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class AdditionalWanderingTrades {
    public static final int INK_SALE_PRICE_PER_RARITY = 8;
    public static final int INK_BUY_PRICE_PER_RARITY = 5;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addWanderingTrades(WandererTradesEvent event) {
        List<VillagerTrades.ItemListing> additionalGenericTrades = List.of(new RandomScrollTrade(new SpellFilter()), new RandomScrollTrade(new SpellFilter()), new RandomScrollTrade(new SpellFilter()), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_COMMON.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_UNCOMMON.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_RARE.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_EPIC.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_LEGENDARY.get())), new InkSellTrade((InkItem)((Object)ItemRegistry.INK_COMMON.get())), new InkSellTrade((InkItem)((Object)ItemRegistry.INK_UNCOMMON.get())), new InkSellTrade((InkItem)((Object)ItemRegistry.INK_RARE.get())), new InkSellTrade((InkItem)((Object)ItemRegistry.INK_EPIC.get())), new InkSellTrade((InkItem)((Object)ItemRegistry.INK_LEGENDARY.get())), new RandomCurioTrade());
        List<ScrollPouchTrade> additionalRareTrades = List.of(SimpleTrade.of((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 64 - random.m_216332_(1, 8)), new ItemStack((ItemLike)Items.f_220224_, random.m_216332_(1, 3)), new ItemStack((ItemLike)ItemRegistry.LOST_KNOWLEDGE_FRAGMENT.get()), 8, 0, 0.05f)), SimpleTrade.of((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 64), new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(48, 64)), new ItemStack((ItemLike)ItemRegistry.HITHER_THITHER_WAND.get()), 1, 0, 0.05f)), new RandomCurioTrade(), new RandomCurioTrade(), new RandomCurioTrade(), new ScrollPouchTrade(), new ScrollPouchTrade());
        event.getGenericTrades().addAll(additionalGenericTrades);
        event.getRareTrades().addAll(additionalRareTrades);
    }

    public static class RandomScrollTrade
    implements VillagerTrades.ItemListing {
        protected final ItemStack price;
        protected final ItemStack price2;
        protected final ItemStack forSale;
        protected final int maxTrades;
        protected final int xp;
        protected final float priceMult;
        protected final SpellFilter spellFilter;
        protected float minQuality;
        protected float maxQuality;

        public RandomScrollTrade(SpellFilter spellFilter) {
            this.spellFilter = spellFilter;
            this.price = new ItemStack((ItemLike)Items.f_42616_);
            this.price2 = ItemStack.f_41583_;
            this.forSale = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            this.maxTrades = 1;
            this.xp = 5;
            this.priceMult = 0.05f;
            this.minQuality = 0.0f;
            this.maxQuality = 1.0f;
        }

        public RandomScrollTrade(SpellFilter filter, float minQuality, float maxQuality) {
            this(filter);
            this.minQuality = minQuality;
            this.maxQuality = maxQuality;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity pTrader, RandomSource random) {
            AbstractSpell spell = this.spellFilter.getRandomSpell(random);
            int level = random.m_216332_(1 + (int)((float)spell.getMaxLevel() * this.minQuality), (int)((float)(spell.getMaxLevel() - 1) * this.maxQuality) + 1);
            ISpellContainer.createScrollContainer(spell, level, this.forSale);
            this.price.m_41764_(spell.getRarity(level).getValue() * 5 + random.m_216332_(4, 7) + level);
            return new MerchantOffer(this.price, this.price2, this.forSale, this.maxTrades, this.xp, this.priceMult);
        }
    }

    public static class InkBuyTrade
    extends SimpleTrade {
        public InkBuyTrade(InkItem item) {
            super((Entity trader, RandomSource random) -> {
                boolean emeralds = random.m_188499_();
                return new MerchantOffer(new ItemStack((ItemLike)item), new ItemStack((ItemLike)(emeralds ? Items.f_42616_ : (ItemLike)ItemRegistry.ARCANE_ESSENCE.get()), 5 * item.getRarity().getValue() / (emeralds ? 1 : 2) + random.m_216332_(2, 3)), 8, 1, 0.05f);
            });
        }
    }

    public static class InkSellTrade
    extends SimpleTrade {
        public InkSellTrade(InkItem item) {
            super((Entity trader, RandomSource random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 8 * item.getRarity().getValue() + random.m_216332_(2, 3)), new ItemStack((ItemLike)item), 4, 1, 0.05f));
        }
    }

    static class RandomCurioTrade
    extends SimpleTrade {
        private RandomCurioTrade() {
            super((trader, random) -> {
                LootContext context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.f_19853_.f_46443_ && !(items = (loottable = trader.f_19853_.m_7654_().m_129898_().m_79217_(IronsSpellbooks.id("magic_items/basic_curios"))).m_230922_(context = new LootContext.Builder((ServerLevel)trader.f_19853_).m_78975_(LootContextParamSets.f_81410_))).isEmpty()) {
                    ItemStack forSale = (ItemStack)items.get(0);
                    ItemStack cost = new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(14, 25));
                    return new MerchantOffer(cost, forSale, 1, 5, 0.5f);
                }
                return null;
            });
        }
    }

    public static class SimpleTrade
    implements VillagerTrades.ItemListing {
        final BiFunction<Entity, RandomSource, MerchantOffer> getOffer;

        protected SimpleTrade(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            this.getOffer = getOffer;
        }

        public static SimpleTrade of(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            return new SimpleTrade(getOffer);
        }

        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            return this.getOffer.apply(pTrader, pRandom);
        }
    }

    static class ScrollPouchTrade
    extends SimpleTrade {
        private ScrollPouchTrade() {
            super((trader, random) -> {
                LootContext context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.f_19853_.f_46443_ && !(items = (loottable = trader.f_19853_.m_7654_().m_129898_().m_79217_(IronsSpellbooks.id("magic_items/scroll_pouch"))).m_230922_(context = new LootContext.Builder((ServerLevel)trader.f_19853_).m_78975_(LootContextParamSets.f_81410_))).isEmpty()) {
                    int quality = 0;
                    ItemStack forSale = new ItemStack((ItemLike)Items.f_151058_).m_41714_((Component)Component.m_237115_((String)"item.irons_spellbooks.scroll_pouch"));
                    ListTag itemsTag = new ListTag();
                    for (ItemStack scroll : items) {
                        itemsTag.add((Object)scroll.m_41739_(new CompoundTag()));
                        if (!(scroll.m_41720_() instanceof Scroll)) continue;
                        quality += ISpellContainer.get(scroll).getSpellAtIndex(0).getRarity().getValue() + 1;
                    }
                    forSale.m_41784_().m_128365_("Items", (Tag)itemsTag);
                    ItemStack cost = new ItemStack((ItemLike)Items.f_42616_, quality * 4 + random.m_216332_(8, 16));
                    return new MerchantOffer(cost, forSale, 1, 5, 0.5f);
                }
                return null;
            });
        }
    }

    static class ScrollMerchantOffer
    extends MerchantOffer {
        final SpellRarity scrollRarity;

        public ScrollMerchantOffer(SpellRarity scrollRarity, int emeralds, int pMaxUses, int pXp, float pPriceMultiplier) {
            super(new ItemStack((ItemLike)ItemRegistry.SCROLL.get()).m_41714_((Component)Component.m_237110_((String)"ui.irons_spellbooks.wandering_trader_scroll", (Object[])new Object[]{scrollRarity.getDisplayName()})), new ItemStack((ItemLike)Items.f_42616_, emeralds), pMaxUses, pXp, pPriceMultiplier);
            this.scrollRarity = scrollRarity;
        }

        public boolean m_45355_(ItemStack offerA, ItemStack offerB) {
            SpellRarity offerARarity = ISpellContainer.get(offerA).getSpellAtIndex(0).getRarity();
            return offerA.m_150930_((Item)ItemRegistry.SCROLL.get()) && offerARarity == this.scrollRarity && offerA.m_41613_() >= this.m_45358_().m_41613_() && this.m_45365_(offerB, this.m_45364_()) && offerB.m_41613_() >= this.m_45364_().m_41613_();
        }

        private boolean m_45365_(ItemStack pOffer, ItemStack pCost) {
            if (pCost.m_41619_() && pOffer.m_41619_()) {
                return true;
            }
            ItemStack itemstack = pOffer.m_41777_();
            if (itemstack.m_41720_().isDamageable(itemstack)) {
                itemstack.m_41721_(itemstack.m_41773_());
            }
            return ItemStack.m_41746_((ItemStack)itemstack, (ItemStack)pCost) && (!pCost.m_41782_() || itemstack.m_41782_() && NbtUtils.m_129235_((Tag)pCost.m_41783_(), (Tag)itemstack.m_41783_(), (boolean)false));
        }

        static VillagerTrades.ItemListing createListing(final SpellRarity scrollRarity, final int emeralds, final int pMaxUses, final int pXp, final float pPriceMultiplier) {
            return new VillagerTrades.ItemListing(){

                @Nullable
                public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
                    return new ScrollMerchantOffer(scrollRarity, emeralds, pMaxUses, pXp, pPriceMultiplier);
                }
            };
        }
    }

    public static class PotionSellTrade
    extends SimpleTrade {
        public PotionSellTrade(@Nullable Potion potion) {
            super((Entity trader, RandomSource random) -> {
                Potion potion1 = potion;
                if (potion1 == null) {
                    List<Potion> potions = ForgeRegistries.POTIONS.getValues().stream().filter(p -> p.m_43488_().size() > 0).toList();
                    potion1 = potions.get(random.m_188503_(potions.size()));
                }
                if (potion1 == null) {
                    potion1 = Potions.f_43602_;
                }
                int amplifier = 0;
                int duration = 0;
                List effects = potion1.m_43488_();
                if (effects.size() > 0) {
                    MobEffectInstance effect = (MobEffectInstance)effects.get(0);
                    amplifier = effect.m_19564_();
                    duration = effect.m_19557_() / 1200;
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(12, 16) + random.m_216332_(4, 6) * amplifier + duration), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion1), 3, 1, 0.05f);
            });
        }
    }

    public static class ExilirSellTrade
    extends SimpleTrade {
        public ExilirSellTrade(boolean onlyLesser, boolean onlyGreater) {
            super((trader, random) -> {
                List<Item> lesser = List.of((Item)ItemRegistry.EVASION_ELIXIR.get(), (Item)ItemRegistry.OAKSKIN_ELIXIR.get(), (Item)ItemRegistry.INVISIBILITY_ELIXIR.get());
                List<Item> greater = List.of((Item)ItemRegistry.GREATER_EVASION_ELIXIR.get(), (Item)ItemRegistry.GREATER_OAKSKIN_ELIXIR.get(), (Item)ItemRegistry.GREATER_INVISIBILITY_ELIXIR.get(), (Item)ItemRegistry.GREATER_HEALING_POTION.get());
                boolean isGreater = onlyLesser ? false : (onlyGreater ? true : random.m_188499_());
                Item item = isGreater ? greater.get(random.m_188503_(greater.size())) : lesser.get(random.m_188503_(lesser.size()));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10 + random.m_216332_(4, 8) * (isGreater ? 2 : 1)), new ItemStack((ItemLike)item), 3, 1, 0.05f);
            });
        }
    }

    public static class ExilirBuyTrade
    extends SimpleTrade {
        public ExilirBuyTrade(boolean onlyLesser, boolean onlyGreater) {
            super((trader, random) -> {
                List<Item> lesser = List.of((Item)ItemRegistry.EVASION_ELIXIR.get(), (Item)ItemRegistry.OAKSKIN_ELIXIR.get(), (Item)ItemRegistry.INVISIBILITY_ELIXIR.get());
                List<Item> greater = List.of((Item)ItemRegistry.GREATER_EVASION_ELIXIR.get(), (Item)ItemRegistry.GREATER_OAKSKIN_ELIXIR.get(), (Item)ItemRegistry.GREATER_INVISIBILITY_ELIXIR.get(), (Item)ItemRegistry.GREATER_HEALING_POTION.get());
                boolean isGreater = onlyLesser ? false : (onlyGreater ? true : random.m_188499_());
                Item item = isGreater ? greater.get(random.m_188503_(greater.size())) : lesser.get(random.m_188503_(lesser.size()));
                return new MerchantOffer(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42616_, 6 + random.m_216332_(3, 6) * (isGreater ? 2 : 1)), 6, 1, 0.05f);
            });
        }
    }

    public static class SimpleSell
    extends SimpleTrade {
        public SimpleSell(int tradeCount, ItemStack sell, int minEmeralds, int maxEmeralds) {
            super((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(minEmeralds, maxEmeralds)), sell, tradeCount, 0, 0.05f));
        }
    }

    public static class SimpleBuy
    extends SimpleTrade {
        public SimpleBuy(int tradeCount, ItemStack buy, int minEmeralds, int maxEmeralds) {
            super((trader, random) -> new MerchantOffer(buy, new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(minEmeralds, maxEmeralds)), tradeCount, 0, 0.05f));
        }
    }
}

