/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network.spell;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.ClientSpellTargetingData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncTargetingData {
    private final UUID targetUUID;
    private final String spellId;

    public ClientboundSyncTargetingData(LivingEntity entity, AbstractSpell spell) {
        this.targetUUID = entity.m_20148_();
        this.spellId = spell.getSpellId();
    }

    public ClientboundSyncTargetingData(FriendlyByteBuf buf) {
        this.targetUUID = buf.m_130259_();
        this.spellId = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.targetUUID);
        buf.m_130070_(this.spellId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientMagicData.setTargetingData(new ClientSpellTargetingData(this.targetUUID, this.spellId)));
        return true;
    }
}

