/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.Registry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class ArcaneAnvilRecipeMaker {
    private ArcaneAnvilRecipeMaker() {
    }

    public static List<ArcaneAnvilRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.of(ArcaneAnvilRecipeMaker.getScrollRecipes(vanillaRecipeFactory, ingredientManager), ArcaneAnvilRecipeMaker.getImbueRecipes(vanillaRecipeFactory, ingredientManager), ArcaneAnvilRecipeMaker.getUpgradeRecipes(vanillaRecipeFactory, ingredientManager)).flatMap(x -> x).toList();
    }

    private static Stream<ArcaneAnvilRecipe> getScrollRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return SpellRegistry.REGISTRY.get().getValues().stream().filter(spell -> spell != SpellRegistry.none() && spell.isEnabled()).sorted(Comparator.comparing(AbstractSpell::getSpellId)).map(ArcaneAnvilRecipeMaker::enumerateScrollCombinations).filter(ArcaneAnvilRecipe::isValid);
    }

    private static Stream<ArcaneAnvilRecipe> getImbueRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        SpellRegistry.REGISTRY.get().getValues().stream().filter(spell -> spell != SpellRegistry.none() && spell.isEnabled()).sorted(Comparator.comparing(AbstractSpell::getSpellId)).forEach(spellType -> Registry.f_122827_.m_123024_().filter(k -> k instanceof SwordItem && k.m_41471_() != null).forEach(swordItem -> {
            ItemStack inputSwordStack = new ItemStack((ItemLike)swordItem);
            IntStream.rangeClosed(spellType.getMinLevel(), spellType.getMaxLevel()).forEach(spellLevel -> {
                leftInputs.add(inputSwordStack);
                rightInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spellType, spellLevel));
                outputs.add(ArcaneAnvilRecipeMaker.getScrollStack(inputSwordStack, spellType, spellLevel));
            });
        }));
        return Stream.of(new ArcaneAnvilRecipe(leftInputs, rightInputs, outputs));
    }

    private static Stream<ArcaneAnvilRecipe> getUpgradeRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            if (item instanceof UpgradeOrbItem) {
                UpgradeOrbItem upgradeOrbItem = (UpgradeOrbItem)((Object)item);
                ForgeRegistries.ITEMS.getValues().forEach(item2 -> {
                    if (Utils.canBeUpgraded(new ItemStack((ItemLike)item2))) {
                        ItemStack left = new ItemStack((ItemLike)item2);
                        ItemStack result = left.m_41777_();
                        UpgradeData.setUpgradeData(result, UpgradeData.NONE.addUpgrade(result, upgradeOrbItem.getUpgradeType(), UpgradeUtils.getRelevantEquipmentSlot(left)));
                        leftInputs.add(left);
                        rightInputs.add(new ItemStack((ItemLike)upgradeOrbItem));
                        outputs.add(result);
                    }
                });
            }
        });
        return Stream.of(new ArcaneAnvilRecipe(leftInputs, rightInputs, outputs));
    }

    private static ArcaneAnvilRecipe enumerateScrollCombinations(AbstractSpell spell) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        IntStream.range(spell.getMinLevel(), spell.getMaxLevel()).forEach(spellLevel -> {
            leftInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spell, spellLevel));
            rightInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spell, spellLevel));
            outputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spell, spellLevel + 1));
        });
        return new ArcaneAnvilRecipe(leftInputs, rightInputs, outputs);
    }

    private static ItemStack getScrollStack(ItemStack stack, AbstractSpell spell, int spellLevel) {
        ItemStack scrollStack = stack.m_41777_();
        ISpellContainer.createScrollContainer(spell, spellLevel, scrollStack);
        return scrollStack;
    }
}

