/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipe;
import io.redspace.ironsspellbooks.jei.JeiPlugin;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ArcaneAnvilRecipeCategory
implements IRecipeCategory<ArcaneAnvilRecipe> {
    public static final RecipeType<ArcaneAnvilRecipe> ARCANE_ANVIL_RECIPE_RECIPE_TYPE = RecipeType.create((String)"irons_spellbooks", (String)"arcane_anvil", ArcaneAnvilRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final String leftSlotName = "leftSlot";
    private final String rightSlotName = "rightSlot";
    private final String outputSlotName = "outputSlot";
    private final int paddingBottom = 15;

    public ArcaneAnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(JeiPlugin.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 15, 0, 0).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.ARCANE_ANVIL_BLOCK.get()));
    }

    public RecipeType<ArcaneAnvilRecipe> getRecipeType() {
        return ARCANE_ANVIL_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return ((Block)BlockRegistry.ARCANE_ANVIL_BLOCK.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ArcaneAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> leftInputs = recipe.leftInputs();
        List<ItemStack> rightInputs = recipe.rightInputs();
        List<ItemStack> outputs = recipe.outputs();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(leftInputs)).setSlotName("leftSlot");
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addItemStacks(rightInputs)).setSlotName("rightSlot");
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(outputs)).setSlotName("outputSlot");
        if (leftInputs.size() == rightInputs.size()) {
            if (leftInputs.size() == outputs.size()) {
                builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, rightInputSlot, outputSlot});
            }
        } else if (leftInputs.size() == outputs.size() && rightInputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, outputSlot});
        } else if (rightInputs.size() == outputs.size() && leftInputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{rightInputSlot, outputSlot});
        }
    }

    public void draw(@NotNull ArcaneAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, @NotNull PoseStack poseStack, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("leftSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional rightStack = recipeSlotsView.findSlotByName("rightSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional outputStack = recipeSlotsView.findSlotByName("outputSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        if (leftStack.isEmpty() || rightStack.isEmpty() || outputStack.isEmpty()) {
            return;
        }
        Item item = ((ItemStack)leftStack.get()).m_41720_();
        if (item instanceof Scroll) {
            Scroll leftScroll = (Scroll)item;
            item = ((ItemStack)rightStack.get()).m_41720_();
            if (item instanceof Scroll) {
                Scroll rightScroll = (Scroll)item;
                item = ((ItemStack)outputStack.get()).m_41720_();
                if (item instanceof Scroll) {
                    Scroll outputScroll = (Scroll)item;
                    Minecraft minecraft = Minecraft.m_91087_();
                    this.drawScrollInfo(minecraft, poseStack, ISpellContainer.get((ItemStack)leftStack.get()), ISpellContainer.get((ItemStack)outputStack.get()));
                }
            }
        }
    }

    private void drawScrollInfo(Minecraft minecraft, PoseStack poseStack, ISpellContainer leftScroll, ISpellContainer outputScroll) {
        SpellData inputSpellData = leftScroll.getSpellAtIndex(0);
        String inputText = String.format("L%d", inputSpellData.getLevel());
        int inputColor = inputSpellData.getSpell().getRarity(inputSpellData.getLevel()).getChatFormatting().m_126665_();
        SpellData outputSpellData = outputScroll.getSpellAtIndex(0);
        String outputText = String.format("L%d", outputSpellData.getLevel());
        int outputColor = outputSpellData.getSpell().getRarity(outputSpellData.getLevel()).getChatFormatting().m_126665_();
        int n = this.getHeight() / 2 + 7;
        Objects.requireNonNull(minecraft.f_91062_);
        int y = n + 9 / 2 - 4;
        int x = 3;
        minecraft.f_91062_.m_92750_(poseStack, inputText, (float)x, (float)y, inputColor);
        minecraft.f_91062_.m_92750_(poseStack, inputText, (float)(x += 50), (float)y, inputColor);
        int outputWidth = minecraft.f_91062_.m_92895_(outputText);
        minecraft.f_91062_.m_92750_(poseStack, outputText, (float)(this.getWidth() - (outputWidth + 3)), (float)y, outputColor);
    }
}

