/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import com.google.common.collect.ImmutableList;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronTile;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronJeiRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public final class AlchemistCauldronRecipeMaker {
    private AlchemistCauldronRecipeMaker() {
    }

    public static List<AlchemistCauldronJeiRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.of(AlchemistCauldronRecipeMaker.getScrollRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getCustomRecipes(vanillaRecipeFactory, ingredientManager), AlchemistCauldronRecipeMaker.getPotionRecipes(vanillaRecipeFactory, ingredientManager)).flatMap(x -> x).toList();
    }

    private static Stream<AlchemistCauldronJeiRecipe> getScrollRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Arrays.stream(SpellRarity.values()).map(AlchemistCauldronRecipeMaker::enumerateSpellsForRarity);
    }

    private static Stream<AlchemistCauldronJeiRecipe> getCustomRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ImmutableList<AlchemistCauldronRecipe> recipes = AlchemistCauldronRecipeRegistry.getRecipes();
        List<ItemStack> reagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeRegistry::isValidIngredient).toList();
        return reagents.stream().map(reagentStack -> {
            ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            AlchemistCauldronRecipeRegistry.getRecipes().forEach(recipe -> {
                if (ItemStack.m_150942_((ItemStack)reagentStack, (ItemStack)recipe.getIngredient())) {
                    catalysts.add(recipe.getInput());
                    ItemStack result = recipe.getResult();
                    if (result.m_41613_() == 4) {
                        result.m_41764_(1);
                    }
                    outputs.add(result);
                }
            });
            return new AlchemistCauldronJeiRecipe(List.of(reagentStack), outputs, catalysts);
        });
    }

    private static Stream<AlchemistCauldronJeiRecipe> getPotionRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        if (!((Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get()).booleanValue()) {
            return Stream.of(new AlchemistCauldronJeiRecipe[0]);
        }
        List<ItemStack> potionReagents = ingredientManager.getAllItemStacks().stream().filter(AlchemistCauldronRecipeMaker::isIngredient).toList();
        return potionReagents.stream().map(reagentStack -> {
            ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            ingredientManager.getAllItemStacks().stream().filter(itemStack -> itemStack.m_41720_() instanceof PotionItem && BrewingRecipeRegistry.hasOutput((ItemStack)itemStack, (ItemStack)reagentStack)).forEach(baseStack -> {
                catalysts.add((ItemStack)baseStack);
                outputs.add(BrewingRecipeRegistry.getOutput((ItemStack)baseStack, (ItemStack)reagentStack));
            });
            return new AlchemistCauldronJeiRecipe(List.of(reagentStack), outputs, catalysts);
        });
    }

    private static List<ItemStack> enumerateScrollLevels(AbstractSpell spell) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        ArrayList<ItemStack> scrolls = new ArrayList<ItemStack>();
        IntStream.rangeClosed(spell.getMinLevel(), spell.getMaxLevel()).forEach(spellLevel -> scrolls.add(AlchemistCauldronRecipeMaker.getScrollStack(scrollStack, spell, spellLevel)));
        return scrolls;
    }

    private static AlchemistCauldronJeiRecipe enumerateSpellsForRarity(SpellRarity spellRarity) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        SpellRegistry.getEnabledSpells().forEach(spell -> IntStream.rangeClosed(spell.getMinLevel(), spell.getMaxLevel()).filter(spellLevel -> spell.getRarity(spellLevel) == spellRarity).forEach(filteredLevel -> inputs.add(AlchemistCauldronRecipeMaker.getScrollStack(scrollStack, spell, filteredLevel))));
        inputs.forEach(itemStack -> {
            catalysts.add(ItemStack.f_41583_);
            outputs.add(new ItemStack((ItemLike)AlchemistCauldronTile.getInkFromScroll(itemStack)));
        });
        return new AlchemistCauldronJeiRecipe(inputs, outputs, catalysts);
    }

    private static ItemStack getScrollStack(ItemStack stack, AbstractSpell spell, int spellLevel) {
        ItemStack scrollStack = stack.m_41777_();
        ISpellContainer.createScrollContainer(spell, spellLevel, scrollStack);
        return scrollStack;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return PotionBrewing.m_43506_((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            IronsSpellbooks.LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStack.toString(), (Object)e);
            return false;
        }
    }
}

