/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class ManaBarOverlay {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    static final int DEFAULT_IMAGE_WIDTH = 98;
    static final int XP_IMAGE_WIDTH = 188;
    static final int IMAGE_HEIGHT = 21;
    static final int HOTBAR_HEIGHT = 25;
    static final int ICON_ROW_HEIGHT = 11;
    static final int CHAR_WIDTH = 6;
    static final int HUNGER_BAR_OFFSET = 50;
    static final int SCREEN_BORDER_MARGIN = 20;
    static final int TEXT_COLOR = ChatFormatting.AQUA.m_126665_();

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!ManaBarOverlay.shouldShowManaBar((Player)player)) {
            return;
        }
        int maxMana = (int)player.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get());
        int mana = ClientMagicData.getPlayerMana();
        int configOffsetY = (Integer)ClientConfigs.MANA_BAR_Y_OFFSET.get();
        int configOffsetX = (Integer)ClientConfigs.MANA_BAR_X_OFFSET.get();
        Anchor anchor = (Anchor)((Object)ClientConfigs.MANA_BAR_ANCHOR.get());
        if (anchor == Anchor.XP && player.m_108634_() > 0.0f) {
            return;
        }
        int barX = ManaBarOverlay.getBarX(anchor, screenWidth) + configOffsetX;
        int barY = ManaBarOverlay.getBarY(anchor, screenHeight, gui) - configOffsetY;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int imageWidth = anchor == Anchor.XP ? 188 : 98;
        int spriteX = anchor == Anchor.XP ? 68 : 0;
        int spriteY = anchor == Anchor.XP ? 40 : 0;
        ForgeGui.m_93133_((PoseStack)poseStack, (int)barX, (int)barY, (float)spriteX, (float)spriteY, (int)imageWidth, (int)21, (int)256, (int)256);
        gui.m_93228_(poseStack, barX, barY, spriteX, spriteY + 21, (int)((double)imageWidth * Math.min((double)mana / (double)maxMana, 1.0)), 21);
        String manaFraction = mana + "/" + maxMana;
        int textX = barX + imageWidth / 2 - (int)(((double)("" + mana).length() + 0.5) * 6.0);
        int textY = barY + (anchor == Anchor.XP ? 3 : 11);
        if (((Boolean)ClientConfigs.MANA_BAR_TEXT_VISIBLE.get()).booleanValue()) {
            gui.m_93082_().m_92750_(poseStack, manaFraction, (float)textX, (float)textY, TEXT_COLOR);
        }
    }

    public static boolean shouldShowManaBar(Player player) {
        Display display = (Display)((Object)ClientConfigs.MANA_BAR_DISPLAY.get());
        return !player.m_5833_() && display != Display.Never && (display == Display.Always || player.m_21093_(itemStack -> itemStack.m_41720_() instanceof CastingItem || ISpellContainer.isSpellContainer(itemStack) && !ISpellContainer.get(itemStack).mustEquip()) || (double)ClientMagicData.getPlayerMana() < player.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()));
    }

    private static int getBarX(Anchor anchor, int screenWidth) {
        if (anchor == Anchor.XP) {
            return screenWidth / 2 - 91 - 3;
        }
        if (anchor == Anchor.Hunger || anchor == Anchor.Center) {
            return screenWidth / 2 - 49 + (anchor == Anchor.Center ? 0 : 50);
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.BottomLeft) {
            return 20;
        }
        return screenWidth - 20 - 98;
    }

    private static int getBarY(Anchor anchor, int screenHeight, ForgeGui gui) {
        if (anchor == Anchor.XP) {
            return screenHeight - 32 + 3 - 8;
        }
        if (anchor == Anchor.Hunger) {
            return screenHeight - (ManaBarOverlay.getAndIncrementRightHeight(gui) - 2) - 10;
        }
        if (anchor == Anchor.Center) {
            return screenHeight - 25 - 27 - 10;
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.TopRight) {
            return 20;
        }
        return screenHeight - 20 - 21;
    }

    private static int getAndIncrementRightHeight(ForgeGui gui) {
        int x = gui.rightHeight;
        gui.rightHeight += 10;
        return x;
    }

    public static enum Anchor {
        Hunger,
        XP,
        Center,
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight;

    }

    public static enum Display {
        Never,
        Always,
        Contextual;

    }
}

