/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.arcane_anvil;

import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.UniqueItem;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MenuRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ArcaneAnvilMenu
extends ItemCombinerMenu {
    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super((MenuType)MenuRegistry.ARCANE_ANVIL_MENU.get(), pContainerId, inventory, containerLevelAccess);
    }

    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_);
    }

    protected boolean m_6560_(Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void m_142365_(Player p_150601_, ItemStack p_150602_) {
        this.f_39769_.m_8020_(0).m_41774_(1);
        this.f_39769_.m_8020_(1).m_41774_(1);
        this.f_39770_.m_39292_((level, pos) -> {
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.8f, 1.1f);
            level.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    protected boolean m_8039_(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.ARCANE_ANVIL_BLOCK.get());
    }

    public void m_6640_() {
        ItemStack result = ItemStack.f_41583_;
        ItemStack baseItemStack = this.f_39769_.m_8020_(0);
        ItemStack modifierItemStack = this.f_39769_.m_8020_(1);
        if (!baseItemStack.m_41619_() && !modifierItemStack.m_41619_()) {
            Object spellContainer;
            Object scrollSlot;
            Item spell12;
            if (baseItemStack.m_41720_() instanceof Scroll && modifierItemStack.m_41720_() instanceof Scroll) {
                SpellData spell2;
                SpellData spell12 = ISpellContainer.get(baseItemStack).getSpellAtIndex(0);
                if (spell12.equals(spell2 = ISpellContainer.get(modifierItemStack).getSpellAtIndex(0)) && spell12.getLevel() < ServerConfigs.getSpellConfig(spell12.getSpell()).maxLevel()) {
                    result = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                    ISpellContainer.createScrollContainer(spell12.getSpell(), spell12.getLevel() + 1, result);
                }
            } else if (baseItemStack.m_41720_() instanceof UniqueItem && (spell12 = modifierItemStack.m_41720_()) instanceof Scroll) {
                SpellData spellData;
                ISpellContainer spellContainer2;
                int matchIndex;
                Scroll scroll = (Scroll)spell12;
                scrollSlot = ISpellContainer.get(modifierItemStack).getSpellAtIndex(0);
                if (ISpellContainer.isSpellContainer(baseItemStack) && (matchIndex = (spellContainer2 = ISpellContainer.get(baseItemStack)).getIndexForSpell(((SpellData)scrollSlot).getSpell())) >= 0 && (spellData = spellContainer2.getSpellAtIndex(matchIndex)).getLevel() < ((SpellData)scrollSlot).getLevel() && spellData.isLocked()) {
                    result = baseItemStack.m_41777_();
                    spellContainer2.removeSpellAtIndex(matchIndex, null);
                    spellContainer2.addSpellAtIndex(((SpellData)scrollSlot).getSpell(), ((SpellData)scrollSlot).getLevel(), matchIndex, true, null);
                    spellContainer2.save(result);
                    result.m_41784_().m_128379_("Improved", true);
                }
            } else if (Utils.canImbue(baseItemStack) && (scrollSlot = modifierItemStack.m_41720_()) instanceof Scroll) {
                Scroll scroll = (Scroll)scrollSlot;
                result = baseItemStack.m_41777_();
                spellContainer = ISpellContainer.getOrCreate(baseItemStack);
                SpellData scrollSlot2 = ISpellContainer.get(modifierItemStack).getSpellAtIndex(0);
                int nextSlotIndex = spellContainer.getNextAvailableIndex();
                if (nextSlotIndex == -1) {
                    nextSlotIndex = 0;
                }
                spellContainer.removeSpellAtIndex(0, null);
                spellContainer.addSpellAtIndex(scrollSlot2.getSpell(), scrollSlot2.getLevel(), nextSlotIndex, false, null);
                spellContainer.save(result);
            } else if (Utils.canBeUpgraded(baseItemStack) && UpgradeData.getUpgradeData(baseItemStack).getCount() < (Integer)ServerConfigs.MAX_UPGRADES.get() && (spellContainer = modifierItemStack.m_41720_()) instanceof UpgradeOrbItem) {
                UpgradeOrbItem upgradeOrb = (UpgradeOrbItem)((Object)spellContainer);
                result = baseItemStack.m_41777_();
                String slot = UpgradeUtils.getRelevantEquipmentSlot(result);
                UpgradeData.getUpgradeData(result).addUpgrade(result, upgradeOrb.getUpgradeType(), slot);
            } else if (modifierItemStack.m_150930_((Item)ItemRegistry.SHRIVING_STONE.get())) {
                result = Utils.handleShriving(baseItemStack);
            }
        }
        this.f_39768_.m_6836_(0, result);
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.f_39768_ && super.m_5882_(pStack, pSlot);
    }
}

