/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.magma_ball;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.acid_orb.AcidOrbRenderer;
import io.redspace.ironsspellbooks.entity.spells.magma_ball.FireBomb;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class MagmaBallRenderer
extends EntityRenderer<FireBomb> {
    private static ResourceLocation TEXTURE = IronsSpellbooks.id("textures/entity/fireball/magma.png");
    private static ResourceLocation[] SWIRL_TEXTURES = new ResourceLocation[]{IronsSpellbooks.id("textures/entity/fireball/swirl_0.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_1.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_2.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_3.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_4.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_5.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_6.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_7.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_8.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_9.png"), IronsSpellbooks.id("textures/entity/fireball/swirl_10.png")};
    private final ModelPart orb;
    private final ModelPart swirl;

    public MagmaBallRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(AcidOrbRenderer.MODEL_LAYER_LOCATION);
        this.orb = modelpart.m_171324_("orb");
        this.swirl = modelpart.m_171324_("swirl");
    }

    public void render(FireBomb entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, entity.m_20191_().m_82376_() * 0.5, 0.0);
        Vec3 motion = entity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)motion.m_165924_(), (double)motion.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_) * 57.2957763671875) + 90.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        float f = (float)entity.f_19797_ + partialTicks;
        float swirlX = Mth.m_14089_((float)(0.08f * f)) * 130.0f;
        float swirlY = Mth.m_14031_((float)(0.08f * f)) * 130.0f;
        float swirlZ = Mth.m_14089_((float)(0.08f * f + 5464.0f)) * 130.0f;
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlX));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlY));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlZ));
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.orb.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlX));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlY));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlZ));
        consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getSwirlTextureLocation(entity)));
        poseStack.m_85841_(1.15f, 1.15f, 1.15f);
        this.swirl.m_104301_(poseStack, consumer, light, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(FireBomb entity) {
        return TEXTURE;
    }

    private ResourceLocation getSwirlTextureLocation(FireBomb entity) {
        int frame = entity.f_19797_ % SWIRL_TEXTURES.length;
        return SWIRL_TEXTURES[frame];
    }
}

