/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.fireball;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.network.spell.ClientboundFieryExplosionParticles;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class MagicFireball
extends AbstractMagicProjectile
implements ItemSupplier {
    public MagicFireball(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public MagicFireball(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.MAGIC_FIREBALL.get()), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        for (int i = 0; i < 8; ++i) {
            Vec3 motion = Utils.getRandomVec3(0.1).m_82546_(this.m_20184_().m_82490_((double)0.1f));
            Vec3 pos = Utils.getRandomVec3(0.3);
            this.f_19853_.m_7106_(ParticleHelper.EMBERS, d0 + pos.f_82479_, d1 + 0.5 + pos.f_82480_, d2 + pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    @Override
    public void impactParticles(double x, double y, double z) {
    }

    @Override
    public float getSpeed() {
        return 1.15f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    @Override
    protected void m_6532_(HitResult hitResult) {
        if (!this.f_19853_.f_46443_) {
            Explosion explosion;
            this.impactParticles(this.f_19790_, this.f_19791_, this.f_19792_);
            float explosionRadius = this.getExplosionRadius();
            float explosionRadiusSqr = explosionRadius * explosionRadius;
            List entities = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius));
            Vec3 losPoint = Utils.raycastForBlock(this.f_19853_, this.m_20182_(), this.m_20182_().m_82520_(0.0, 2.0, 0.0), ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceSqr = entity.m_20238_(hitResult.m_82450_());
                if (!(distanceSqr < (double)explosionRadiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight(this.f_19853_, losPoint, entity.m_20191_().m_82399_(), true)) continue;
                double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                float damage = (float)((double)this.damage * p);
                DamageSources.applyDamage(entity, damage, ((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).getDamageSource((Entity)this, this.m_37282_()));
            }
            if (((Boolean)ServerConfigs.SPELL_GREIFING.get()).booleanValue() && !ForgeEventFactory.onExplosionStart((Level)this.f_19853_, (Explosion)(explosion = new Explosion(this.f_19853_, null, ((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).getDamageSource((Entity)this, this.m_37282_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionRadius() / 2.0f, true, Explosion.BlockInteraction.DESTROY)))) {
                explosion.m_46061_();
                explosion.m_46075_(false);
            }
            Messages.sendToPlayersTrackingEntity(new ClientboundFieryExplosionParticles(new Vec3(this.m_20185_(), this.m_20186_() + (double)0.15f, this.m_20189_()), this.getExplosionRadius()), (Entity)this);
            this.m_5496_(SoundEvents.f_11913_, 4.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            this.m_146870_();
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42613_);
    }
}

