/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.item.consumables.SimpleElixir;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GenerateSiteData {
    private static final LazyOptional<List<Item>> ITEM_BLACKLIST = LazyOptional.of(() -> List.of((Item)ItemRegistry.INVISIBILITY_RING.get(), (Item)ItemRegistry.TEST_CLAYMORE.get(), (Item)ItemRegistry.LURKER_RING.get(), (Item)ItemRegistry.SPELLBREAKER.get(), (Item)ItemRegistry.AUTOLOADER_CROSSBOW.get(), (Item)ItemRegistry.STAFF_OF_THE_NINES.get(), (Item)ItemRegistry.DEV_CROWN.get()));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.irons_spellbooks.generate_recipe_data.failed"));
    private static final String RECIPE_DATA_TEMPLATE = "- id: \"%s\"\n  name: \"%s\"\n  path: \"%s\"\n  group: \"%s\"\n  craftingType: \"%s\"\n  item0Id: \"%s\"\n  item0: \"%s\"\n  item0Path: \"%s\"\n  item1Id: \"%s\"\n  item1: \"%s\"\n  item1Path: \"%s\"\n  item2Id: \"%s\"\n  item2: \"%s\"\n  item2Path: \"%s\"\n  item3Id: \"%s\"\n  item3: \"%s\"\n  item3Path: \"%s\"\n  item4Id: \"%s\"\n  item4: \"%s\"\n  item4Path: \"%s\"\n  item5Id: \"%s\"\n  item5: \"%s\"\n  item5Path: \"%s\"\n  item6Id: \"%s\"\n  item6: \"%s\"\n  item6Path: \"%s\"\n  item7Id: \"%s\"\n  item7: \"%s\"\n  item7Path: \"%s\"\n  item8Id: \"%s\"\n  item8: \"%s\"\n  item8Path: \"%s\"\n  tooltip: \"%s\"\n  description: \"\"\n\n";
    private static final String SPELL_DATA_TEMPLATE = "- name: \"%s\"\n  school: \"%s\"\n  icon: \"%s\"\n  level: \"%d to %d\"\n  mana: \"%d to %d\"\n  cooldown: \"%ds\"\n  cast_type: \"%s\"\n  rarity: \"%s to %s\"\n  description: \"%s\"\n  u1: \"%s\"\n  u2: \"%s\"\n  u3: \"%s\"\n  u4: \"%s\"\n\n";

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"generateSiteData").requires(p_138819_ -> p_138819_.m_6761_(2))).executes(commandContext -> GenerateSiteData.generateSiteData((CommandSourceStack)commandContext.getSource())));
    }

    private static int generateSiteData(CommandSourceStack source) {
        GenerateSiteData.generateRecipeData(source);
        GenerateSiteData.generateSpellData();
        return 1;
    }

    private static void generateRecipeData(CommandSourceStack source) {
        try {
            StringBuilder itemBuilder = new StringBuilder();
            StringBuilder armorBuilder = new StringBuilder();
            StringBuilder spellbookBuilder = new StringBuilder();
            StringBuilder curioBuilder = new StringBuilder();
            StringBuilder blockBuilder = new StringBuilder();
            HashSet<Item> itemsTracked = new HashSet<Item>();
            itemsTracked.add((Item)ItemRegistry.WIMPY_SPELL_BOOK.get());
            itemsTracked.add((Item)ItemRegistry.LEGENDARY_SPELL_BOOK.get());
            itemsTracked.add(Items.f_42675_);
            GenerateSiteData.handleAffinityRingEntry(curioBuilder, itemsTracked, source);
            ForgeRegistries.ITEMS.getValues().stream().forEach(item -> {
                ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey(item);
                String tooltip = GenerateSiteData.getTooltip(source.m_230896_(), new ItemStack((ItemLike)item));
                if (itemResource.m_135827_().equals("irons_spellbooks") && !itemsTracked.contains(item) && !((List)ITEM_BLACKLIST.resolve().get()).contains(item)) {
                    Recipe recipe = GenerateSiteData.getRecipeFor(source, item);
                    String name = item.m_7626_(ItemStack.f_41583_).getString();
                    if (!(item.m_5524_().contains("patchouli") || item.m_5524_().contains("spawn_egg") || item.m_5524_().equals("item.irons_spellbooks.scroll"))) {
                        if (item instanceof ArmorItem) {
                            if (recipe != null) {
                                String[] words = name.split(" ");
                                String group = Arrays.stream(words).limit(words.length - 1).collect(Collectors.joining(" "));
                                GenerateSiteData.appendToBuilder(armorBuilder, recipe, GenerateSiteData.getRecipeData(recipe), group, tooltip);
                            } else {
                                GenerateSiteData.appendToBuilder2(armorBuilder, name, itemResource, tooltip);
                            }
                        } else if (item instanceof UniqueSpellBook) {
                            GenerateSiteData.appendToBuilder2(spellbookBuilder, name, itemResource, GenerateSiteData.getSpells(new ItemStack((ItemLike)item)));
                        } else if (item instanceof SpellBook || item instanceof ExtendedSwordItem || item instanceof CastingItem) {
                            if (recipe != null) {
                                GenerateSiteData.appendToBuilder(spellbookBuilder, recipe, GenerateSiteData.getRecipeData(recipe), "", tooltip);
                            } else {
                                GenerateSiteData.appendToBuilder2(spellbookBuilder, name, itemResource, tooltip);
                            }
                        } else if (item instanceof CurioBaseItem) {
                            if (recipe != null) {
                                GenerateSiteData.appendToBuilder(curioBuilder, recipe, GenerateSiteData.getRecipeData(recipe), "", tooltip);
                            } else {
                                GenerateSiteData.appendToBuilder2(curioBuilder, name, itemResource, tooltip);
                            }
                        } else if (item instanceof BlockItem) {
                            if (recipe != null) {
                                GenerateSiteData.appendToBuilder(blockBuilder, recipe, GenerateSiteData.getRecipeData(recipe), "", tooltip);
                            } else {
                                GenerateSiteData.appendToBuilder2(blockBuilder, name, itemResource, tooltip);
                            }
                        } else if (recipe != null) {
                            GenerateSiteData.appendToBuilder(itemBuilder, recipe, GenerateSiteData.getRecipeData(recipe), GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                        } else {
                            GenerateSiteData.appendToBuilder3(itemBuilder, name, itemResource, GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                        }
                    }
                    itemsTracked.add((Item)item);
                }
            });
            BufferedWriter file = new BufferedWriter(new FileWriter("item_data.yml"));
            file.write(GenerateSiteData.postProcess(itemBuilder));
            file.close();
            file = new BufferedWriter(new FileWriter("armor_data.yml"));
            file.write(GenerateSiteData.postProcess(armorBuilder));
            file.close();
            file = new BufferedWriter(new FileWriter("curio_data.yml"));
            file.write(GenerateSiteData.postProcess(curioBuilder));
            file.close();
            file = new BufferedWriter(new FileWriter("spellbook_data.yml"));
            file.write(GenerateSiteData.postProcess(spellbookBuilder));
            file.close();
            file = new BufferedWriter(new FileWriter("block_data.yml"));
            file.write(GenerateSiteData.postProcess(blockBuilder));
            file.close();
        }
        catch (Exception e) {
            IronsSpellbooks.LOGGER.debug(e.getMessage());
        }
    }

    private static void handleAffinityRingEntry(StringBuilder curioBuilder, Set<Item> itemsTracked, CommandSourceStack source) {
        CurioBaseItem item = (CurioBaseItem)((Object)ItemRegistry.AFFINITY_RING.get());
        itemsTracked.add(item);
        ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey((Object)item);
        String name = item.m_7626_(ItemStack.f_41583_).getString();
        GenerateSiteData.appendToBuilder2(curioBuilder, name, itemResource, "Affinity Rings are randomly generated as loot, and will boost the level of a select spell by one. This effect can stack.");
    }

    private static String handleGenericItemGrouping(Item item) {
        if (item instanceof InkItem) {
            return "Ink";
        }
        if (item.m_5524_().contains("rune")) {
            return "Runes";
        }
        if (item instanceof UpgradeOrbItem || item == ItemRegistry.UPGRADE_ORB.get()) {
            return "Upgrade Orbs";
        }
        if (item instanceof SimpleElixir) {
            return "Elixirs";
        }
        return "All";
    }

    @NotNull
    private static ArrayList<RecipeIngredientData> getRecipeData(Recipe<?> recipe) {
        ResourceLocation resultItemResourceLocation = ForgeRegistries.ITEMS.getKey((Object)recipe.m_8043_().m_41720_());
        ArrayList<RecipeIngredientData> recipeData = new ArrayList<RecipeIngredientData>(10);
        recipeData.add(new RecipeIngredientData(resultItemResourceLocation.toString(), recipe.m_8043_().m_41720_().m_7626_(ItemStack.f_41583_).getString(), String.format("/img/items/%s.png", resultItemResourceLocation.m_135815_()), recipe.m_8043_().m_41720_()));
        if (recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe) {
            recipe.m_7527_().forEach(ingredient -> GenerateSiteData.handleIngredient(ingredient, recipeData, recipe));
        } else if (recipe instanceof UpgradeRecipe) {
            UpgradeRecipe upgradeRecipe = (UpgradeRecipe)recipe;
            GenerateSiteData.handleIngredient(upgradeRecipe.f_44518_, recipeData, recipe);
            GenerateSiteData.handleIngredient(upgradeRecipe.f_44519_, recipeData, recipe);
        }
        return recipeData;
    }

    @Nullable
    private static Recipe getRecipeFor(CommandSourceStack sourceStack, Item item) {
        for (Recipe recipe : sourceStack.getRecipeManager().m_44051_()) {
            if (!recipe.m_8043_().m_150930_(item)) continue;
            return recipe;
        }
        return null;
    }

    private static String postProcess(StringBuilder sb) {
        return sb.toString().replace("netherite_spell_book.png", "netherite_spell_book.gif").replace("ruined_book.png", "ruined_book.gif").replace("lightning_bottle.png", "lightning_bottle.gif").replace("cinder_essence.png", "cinder_essence.gif").replace("nature_upgrade_orb.png", "nature_upgrade_orb.gif").replace("evasion_elixir.png", "evasion_elixir.gif").replace("/upgrade_orb.png", "/upgrade_orb.gif").replace("fire_upgrade_orb.png", "fire_upgrade_orb.gif").replace("holy_upgrade_orb.png", "holy_upgrade_orb.gif").replace("lightning_upgrade_orb.png", "lightning_upgrade_orb.gif").replace("ender_upgrade_orb.png", "ender_upgrade_orb.gif").replace("mana_upgrade_orb.png", "upgrade_orb_mana.gif").replace("protection_upgrade_orb.png", "upgrade_orb_protection.gif").replace("ice_upgrade_orb.png", "upgrade_orb_ice.gif").replace("evocation_upgrade_orb.png", "upgrade_orb_evocation.gif").replace("cooldown_upgrade_orb.png", "upgrade_orb_cooldown.gif").replace("blood_upgrade_orb.png", "upgrade_orb_blood.gif").replace("wayward_compass.png", "wayward_compass.gif");
    }

    private static String getSpells(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof SpellBook) {
            ISpellContainer spellList = ISpellContainer.get(itemStack);
            return spellList.getActiveSpells().stream().map(spell -> spell.getSpell().getDisplayName(null).getString() + " (" + spell.getLevel() + ")").collect(Collectors.joining(", "));
        }
        return "";
    }

    private static String getTooltip(ServerPlayer player, ItemStack itemStack) {
        return Arrays.stream(itemStack.m_41651_((Player)player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().skip(1L).map(Component::getString).filter(x -> x.trim().length() > 0).collect(Collectors.joining(", ")).replace(":,", ": ").replace("  ", " ").split(",")).filter(item -> !item.contains("Slot")).collect(Collectors.joining(",")).trim().replace(":", ":<br>");
    }

    private static void appendToBuilder(StringBuilder sb, Recipe recipe, List<RecipeIngredientData> recipeIngredientData, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).path, group, recipe.m_6671_(), GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).path, tooltip));
    }

    private static void appendToBuilder2(StringBuilder sb, String name, ResourceLocation itemResource, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.m_135815_()), "", "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void appendToBuilder3(StringBuilder sb, String name, ResourceLocation itemResource, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.m_135815_()), group, "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void handleIngredient(Ingredient ingredient, ArrayList<RecipeIngredientData> recipeData, Recipe recipe) {
        Arrays.stream(ingredient.m_43908_()).findFirst().ifPresentOrElse(itemStack -> {
            ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            String path = "";
            path = itemResource.toString().contains("irons_spellbooks") ? String.format("/img/items/%s.png", itemResource.m_135815_()) : String.format("/img/items/minecraft/%s.png", itemResource.m_135815_());
            if (itemStack.m_204117_(ModTags.INSCRIBED_RUNES) && recipe.m_8043_().m_150930_((Item)ItemRegistry.BLANK_RUNE.get())) {
                path = "/img/items/all_runes.gif";
            }
            recipeData.add(new RecipeIngredientData(itemResource.toString(), itemStack.m_41720_().m_7626_(ItemStack.f_41583_).getString(), path, recipe.m_8043_().m_41720_()));
        }, () -> recipeData.add(RecipeIngredientData.EMPTY));
    }

    private static RecipeIngredientData getRecipeDataAtIndex(List<RecipeIngredientData> recipeIngredientData, int index) {
        if (index < recipeIngredientData.size()) {
            return recipeIngredientData.get(index);
        }
        return RecipeIngredientData.EMPTY;
    }

    private static void generateSpellData() {
        try {
            StringBuilder sb = new StringBuilder();
            SpellRegistry.REGISTRY.get().getValues().stream().filter(st -> st.isEnabled() && st != SpellRegistry.none()).forEach(spellType -> {
                int spellMin = spellType.getMinLevel();
                int spellMax = spellType.getMaxLevel();
                List<String> uniqueInfo = GenerateSiteData.processUniqueInfo(spellType);
                String u1 = uniqueInfo.size() >= 1 ? uniqueInfo.get(0) : "";
                String u2 = uniqueInfo.size() >= 2 ? uniqueInfo.get(1) : "";
                String u3 = uniqueInfo.size() >= 3 ? uniqueInfo.get(2) : "";
                String u4 = uniqueInfo.size() >= 4 ? uniqueInfo.get(3) : "";
                sb.append(String.format(SPELL_DATA_TEMPLATE, GenerateSiteData.handleCapitalization(spellType.getSpellName()), GenerateSiteData.handleCapitalization(spellType.getSchoolType().getDisplayName().getString()), String.format("/img/spells/%s.png", spellType.getSpellName()), spellType.getMinLevel(), spellType.getMaxLevel(), spellType.getManaCost(spellMin), spellType.getManaCost(spellMax), spellType.getSpellCooldown(), GenerateSiteData.handleCapitalization(spellType.getCastType().name()), GenerateSiteData.handleCapitalization(spellType.getRarity(spellMin).name()), GenerateSiteData.handleCapitalization(spellType.getRarity(spellMax).name()), Component.m_237115_((String)String.format("%s.guide", spellType.getComponentId())).getString(), u1, u2, u3, u4));
            });
            BufferedWriter file = new BufferedWriter(new FileWriter("spell_data.yml"));
            file.write(sb.toString());
            file.close();
        }
        catch (Exception e) {
            IronsSpellbooks.LOGGER.debug(e.getMessage());
        }
    }

    private static List<String> processUniqueInfo(AbstractSpell spell) {
        ArrayList<String> text = new ArrayList<String>();
        List<MutableComponent> uniqueInfoMin = spell.getUniqueInfo(spell.getMinLevel(), null);
        List<MutableComponent> uniqueInfoMax = spell.getUniqueInfo(spell.getMaxLevel(), null);
        for (int i = 0; i < uniqueInfoMax.size(); ++i) {
            String[] splitMin = uniqueInfoMin.get(i).getString().split(" ");
            String[] splitMax = uniqueInfoMax.get(i).getString().split(" ");
            int k = -1;
            for (int j = 0; j < splitMin.length; ++j) {
                if (!splitMin[j].matches("\\d\\.?\\d*(s|m|%)*")) continue;
                k = j;
                break;
            }
            if (k >= 0 && !splitMin[k].equals(splitMax[k])) {
                text.add(String.format(uniqueInfoMin.get(i).getString().replaceFirst(splitMin[k], "%s"), String.format("%s-%s", splitMin[k], splitMax[k])));
                continue;
            }
            text.add(uniqueInfoMin.get(i).getString());
        }
        return text;
    }

    public static String handleCapitalization(String input) {
        return Arrays.stream(input.toLowerCase().split("[ |_]")).map(word -> {
            if (word.equals("spell")) {
                return "";
            }
            String first = word.substring(0, 1);
            String rest = word.substring(1);
            return first.toUpperCase() + rest;
        }).collect(Collectors.joining(" ")).trim();
    }

    private record RecipeIngredientData(String id, String name, String path, Item item) {
        public static RecipeIngredientData EMPTY = new RecipeIngredientData("", "", "", null);
    }

    private static enum CraftingType {
        CRAFTING_TABLE,
        SMITHING_TABLE,
        NOT_CRAFTABLE;

    }
}

