/*
 * Decompiled with CFR 0.152.
 */
package com.sudolev.interiors.content.block.chair;

import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.sudolev.interiors.Utils;
import com.sudolev.interiors.content.block.chair.DirectionalSeatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ChairBlock
extends DirectionalSeatBlock
implements ProperWaterloggedBlock {
    public static final EnumProperty<ArmrestConfiguration> ARMRESTS = EnumProperty.m_61587_((String)"armrests", ArmrestConfiguration.class);
    public static final BooleanProperty CROPPED_BACK = BooleanProperty.m_61465_((String)"cropped_back");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected final DyeColor color;

    public ChairBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(ARMRESTS, (Comparable)((Object)ArmrestConfiguration.DEFAULT))).m_61124_((Property)CROPPED_BACK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ARMRESTS}).m_61104_(new Property[]{CROPPED_BACK});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public abstract VoxelShape shape();

    public void m_5548_(BlockGetter reader, Entity entity) {
        BlockPos pos = entity.m_20183_();
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !ChairBlock.canBePickedUp((Entity)entity) || ChairBlock.isSeatOccupied((Level)entity.f_19853_, (BlockPos)pos)) {
            if (entity.m_20162_()) {
                super.m_5548_(reader, entity);
                return;
            }
            Vec3 vec3 = entity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * 0.66 * d0, vec3.f_82481_);
            }
            return;
        }
        if (reader.m_8055_(pos).m_60734_() != this) {
            return;
        }
        ChairBlock.sitDown((Level)entity.f_19853_, (BlockPos)pos, (Entity)entity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Vec3 clickPos = VecHelper.getCenterOf((Vec3i)pos).m_82546_(context.m_43720_());
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                BlockState blockState;
                if (clickPos.f_82479_ > 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case SOUTH: {
                BlockState blockState;
                if (clickPos.f_82479_ < 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case WEST: {
                BlockState blockState;
                if (clickPos.f_82481_ < 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case EAST: {
                BlockState blockState;
                if (clickPos.f_82481_ > 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            default: {
                BlockState blockState = state = state;
            }
        }
        if (!world.f_46443_) {
            world.m_7731_(pos, state, 3);
        }
        return InteractionResult.SUCCESS;
    }

    private BlockState toggleBackCrop(BlockState state) {
        boolean currentValue = (Boolean)state.m_61143_((Property)CROPPED_BACK);
        return (BlockState)state.m_61124_((Property)CROPPED_BACK, (Comparable)Boolean.valueOf(!currentValue));
    }

    private BlockState toggleLeft(BlockState state) {
        return (BlockState)state.m_61124_(ARMRESTS, (Comparable)((Object)(switch ((ArmrestConfiguration)((Object)state.m_61143_(ARMRESTS))) {
            default -> throw new IncompatibleClassChangeError();
            case ArmrestConfiguration.BOTH -> ArmrestConfiguration.RIGHT;
            case ArmrestConfiguration.NONE -> ArmrestConfiguration.LEFT;
            case ArmrestConfiguration.LEFT -> ArmrestConfiguration.NONE;
            case ArmrestConfiguration.RIGHT -> ArmrestConfiguration.BOTH;
        })));
    }

    private BlockState toggleRight(BlockState state) {
        return (BlockState)state.m_61124_(ARMRESTS, (Comparable)((Object)(switch ((ArmrestConfiguration)((Object)state.m_61143_(ARMRESTS))) {
            default -> throw new IncompatibleClassChangeError();
            case ArmrestConfiguration.BOTH -> ArmrestConfiguration.LEFT;
            case ArmrestConfiguration.NONE -> ArmrestConfiguration.RIGHT;
            case ArmrestConfiguration.LEFT -> ArmrestConfiguration.BOTH;
            case ArmrestConfiguration.RIGHT -> ArmrestConfiguration.NONE;
        })));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!world.f_46443_) {
            world.m_7731_(pos, this.toggleBackCrop(state), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> this.shape();
            case Direction.SOUTH -> Utils.rotateShape(Direction.NORTH, Direction.WEST, this.shape());
            case Direction.WEST -> Utils.rotateShape(Direction.NORTH, Direction.EAST, this.shape());
            default -> Utils.rotateShape(Direction.NORTH, Direction.SOUTH, this.shape());
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public static enum ArmrestConfiguration implements StringRepresentable
    {
        BOTH,
        NONE,
        LEFT,
        RIGHT;

        public static final ArmrestConfiguration DEFAULT;

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }

        static {
            DEFAULT = BOTH;
        }
    }
}

