/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.BulletWeapon;
import immersive_aircraft.network.c2s.FireMessage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;

public class HeavyCrossbow
extends BulletWeapon {
    private static final float MAX_COOLDOWN = 1.0f;
    private float cooldown = 0.0f;

    public HeavyCrossbow(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected float getBarrelLength() {
        return 1.25f;
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.7f, 0.0f, 1.0f);
    }

    public float getVelocity() {
        return 3.0f;
    }

    public float getInaccuracy() {
        return 0.0f;
    }

    @Override
    protected Entity getBullet(Entity shooter, Vector4f position, Vector3f direction) {
        Arrow arrow = new Arrow(shooter.m_9236_(), (double)position.m_123601_(), (double)position.m_123615_(), (double)position.m_123616_());
        arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        arrow.m_5602_(this.getEntity().m_6688_());
        arrow.m_6686_((double)direction.m_122239_(), (double)(direction.m_122260_() + 0.1f), (double)direction.m_122269_(), this.getVelocity(), this.getInaccuracy());
        ItemStack ammoStack = this.getAmmoStack();
        if (ammoStack != null) {
            arrow.m_36878_(ammoStack);
        }
        return arrow;
    }

    @Override
    public void tick() {
        this.cooldown -= 0.05f;
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().arrowAmmunition, 50)) {
            super.fire(direction);
        }
    }

    @Override
    public void clientFire(int index) {
        if (this.cooldown <= 0.0f) {
            this.cooldown = 1.0f;
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    private Vector3f getDirection() {
        Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
        direction.m_122249_(new Matrix3f(this.getMount().transform()));
        direction.m_122249_(this.getEntity().getVehicleNormalTransform());
        return direction;
    }
}

