/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;

public class BBModelRenderer {
    public static <T extends AircraftEntity> void renderModel(BBModel model, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        model.root.forEach(object -> BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
    }

    public static <T extends AircraftEntity> void renderObject(BBModel model, BBObject object, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        BBAnimation animation;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)object.origin.m_122239_(), (double)object.origin.m_122260_(), (double)object.origin.m_122269_());
        if (!model.animations.isEmpty() && (animation = model.animations.get(0)).hasAnimator(object.uuid)) {
            Vector3f position = animation.sample(object.uuid, BBAnimator.Channel.POSITION, time);
            position.m_122261_(0.0625f);
            matrixStack.m_85837_((double)position.m_122239_(), (double)position.m_122260_(), (double)position.m_122269_());
            Vector3f rotation = animation.sample(object.uuid, BBAnimator.Channel.ROTATION, time);
            rotation.m_122261_(0.017453294f);
            matrixStack.m_85845_(Utils.fromZYX(rotation));
            Vector3f scale = animation.sample(object.uuid, BBAnimator.Channel.SCALE, time);
            matrixStack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
        }
        matrixStack.m_85845_(Utils.fromZYX(object.rotation));
        if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            if (modelPartRenderer != null) {
                modelPartRenderer.animate(bone.name, entity, matrixStack, time);
            }
        }
        if (object instanceof BBBone) {
            matrixStack.m_85837_((double)(-object.origin.m_122239_()), (double)(-object.origin.m_122260_()), (double)(-object.origin.m_122269_()));
        }
        if (modelPartRenderer == null || !modelPartRenderer.render(object.name, model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer)) {
            if (object instanceof BBFaceContainer) {
                BBFaceContainer cube = (BBFaceContainer)((Object)object);
                BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumerProvider, light, red, green, blue, alpha, 1.0f, 1.0f, 0.0f, 0.0f, null);
            } else if (object instanceof BBBone) {
                BBBone bone = (BBBone)object;
                boolean shouldRender = bone.visibility;
                if (bone.name.equals("lod0")) {
                    shouldRender = entity.isWithinParticleRange();
                } else if (bone.name.equals("lod1")) {
                    boolean bl = shouldRender = !entity.isWithinParticleRange();
                }
                if (shouldRender) {
                    bone.children.forEach(child -> BBModelRenderer.renderObject(model, child, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
                }
            }
        }
        matrixStack.m_85849_();
    }

    public static void renderFaces(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float red, float green, float blue, float alpha, float uScale, float vScale, float uOffset, float vOffset, VertexConsumer overrideVertexConsumer) {
        PoseStack.Pose last = matrixStack.m_85850_();
        Matrix4f positionMatrix = last.m_85861_();
        Matrix3f normalMatrix = last.m_85864_();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = overrideVertexConsumer == null ? vertexConsumerProvider.m_6299_(cube.enableCulling() ? RenderType.m_110452_((ResourceLocation)face.texture.location) : RenderType.m_110458_((ResourceLocation)face.texture.location)) : overrideVertexConsumer;
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                vertexConsumer.m_85982_(positionMatrix, v.x, v.y, v.z).m_85950_(red, green, blue, alpha).m_7421_(v.u * uScale + uOffset, v.v * vScale + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, v.nx, v.ny, v.nz).m_5752_();
            }
        }
    }

    public static void renderBanner(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, boolean isBanner, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
            float[] fs = ((DyeColor)pair.getSecond()).m_41068_();
            Holder bannerPattern = (Holder)pair.getFirst();
            bannerPattern.m_203543_().ifPresent(key -> {
                Material spriteIdentifier = isBanner ? Sheets.m_234347_((ResourceKey)key) : Sheets.m_234349_((ResourceKey)key);
                VertexConsumer vertexConsumer = spriteIdentifier.m_119194_(vertexConsumers, RenderType::m_110482_);
                TextureAtlasSprite sprite = spriteIdentifier.m_119204_();
                BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumers, light, fs[0], fs[1], fs[2], 1.0f, sprite.m_118410_() - sprite.m_118409_(), sprite.m_118412_() - sprite.m_118411_(), sprite.m_118409_(), sprite.m_118411_(), vertexConsumer);
            });
        }
    }

    public static void renderSailObject(BBMesh cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha) {
        PoseStack.Pose last = matrixStack.m_85850_();
        Matrix4f positionMatrix = last.m_85861_();
        Matrix3f normalMatrix = last.m_85864_();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)face.texture.location));
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                float distance = (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
                double angle = ((double)(v.x + v.z) + (double)v.y * 0.25) * 4.0 + (double)(time * 4.0f);
                double scale = 0.025 * (double)distance;
                float x = (float)((Math.cos(angle) + Math.cos(angle * 1.7)) * scale);
                float z = (float)((Math.sin(angle) + Math.sin(angle * 1.7)) * scale);
                vertexConsumer.m_85982_(positionMatrix, v.x + x, v.y, v.z + z).m_85950_(red, green, blue, alpha).m_7421_(v.u, v.v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, v.nx, v.ny, v.nz).m_5752_();
            }
        }
    }
}

