/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.registry;

import dev.architectury.registry.registries.DeferredRegister;
import gardensofthedead.GardensOfTheDead;
import gardensofthedead.registry.ModParticleTypes;
import gardensofthedead.registry.ModPlacedFeatures;
import gardensofthedead.registry.ModSoundEvents;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModBiomes {
    public static DeferredRegister<Biome> BIOME_REGISTER = DeferredRegister.create((String)"gardens_of_the_dead", (ResourceKey)Registry.f_122885_);
    public static final ResourceKey<Biome> SOULBLIGHT_FOREST = ModBiomes.register("soulblight_forest", ModBiomes::soulblightForest);
    public static final ResourceKey<Biome> WHISTLING_WOODS = ModBiomes.register("whistling_woods", ModBiomes::whistlingWoods);

    private static ResourceKey<Biome> register(String name, Supplier<Biome> biomeSupplier) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)GardensOfTheDead.id(name));
        BIOME_REGISTER.register(key.m_135782_().m_135815_(), biomeSupplier);
        return key;
    }

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    public static Biome soulblightForest() {
        double energyBudget = 1.0;
        double charge = 0.8;
        MobSpawnSettings spawnSettings = new MobSpawnSettings.Builder().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 3, 5, 5)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 4, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20531_, 5, 2, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20456_, 21, 3, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20511_, 10, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20482_, 60, 1, 2)).m_48370_(EntityType.f_20524_, energyBudget, charge).m_48370_(EntityType.f_20566_, energyBudget, charge).m_48370_(EntityType.f_20531_, energyBudget, charge).m_48370_(EntityType.f_20456_, energyBudget, charge).m_48370_(EntityType.f_20511_, energyBudget, charge).m_48370_(EntityType.f_20482_, energyBudget, charge).m_48381_();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().m_204198_(GenerationStep.Carving.AIR, Carvers.f_126853_).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.f_195274_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195296_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195299_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195298_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195284_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195285_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195294_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195316_).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.SOULBLIGHT_FUNGI.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.SOULBLIGHT_FOREST_VEGETATION.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.SHORT_STANDING_SOUL_SPORE_PATCH.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.LONG_STANDING_SOUL_SPORE_PATCH.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.SHORT_HANGING_SOUL_SPORE_PATCH.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.LONG_HANGING_SOUL_SPORE_PATCH.get()));
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126773_((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(5847585).m_48040_(ModBiomes.calculateSkyColor(2.0f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ModParticleTypes.SOULBLIGHT_SPORE.get(), 0.01f)).m_48023_(SoundEvents.f_11954_).m_48027_(new AmbientMoodSettings(SoundEvents.f_12007_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings(SoundEvents.f_11901_, 0.0111)).m_48021_(Musics.m_11653_((SoundEvent)((SoundEvent)ModSoundEvents.SOULBLIGHT_FOREST_MUSIC.get()))).m_48018_()).m_47605_(spawnSettings).m_47601_(generationSettings.m_47831_()).m_47592_();
    }

    public static Biome whistlingWoods() {
        MobSpawnSettings spawnSettings = new MobSpawnSettings.Builder().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20531_, 1, 2, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20456_, 9, 3, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20511_, 5, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20482_, 60, 1, 2)).m_48381_();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().m_204198_(GenerationStep.Carving.AIR, Carvers.f_126853_).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.f_195274_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195296_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195299_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195284_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195285_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_).m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195294_).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.NETHER_WART_BLOCK_PILE.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.DENSE_WEEPING_VINES.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.NOISY_CRIMSON_FUNGI.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.WHISTLECANE_COLUMN.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.TALL_BLISTERCROWN_PATCH.get())).m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.getHolder((PlacedFeature)ModPlacedFeatures.WHISTLING_WOODS_VEGETATION.get()));
        BiomeDefaultFeatures.m_126773_((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(6164760).m_48040_(ModBiomes.calculateSkyColor(2.0f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123784_, 0.01f)).m_48023_(SoundEvents.f_11954_).m_48027_(new AmbientMoodSettings(SoundEvents.f_12007_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings(SoundEvents.f_11901_, 0.0111)).m_48021_(Musics.m_11653_((SoundEvent)((SoundEvent)ModSoundEvents.WHISTLING_WOODS_MUSIC.get()))).m_48018_()).m_47605_(spawnSettings).m_47601_(generationSettings.m_47831_()).m_47592_();
    }
}

