/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.feature;

import com.mojang.serialization.Codec;
import gardensofthedead.block.SoulSporeBaseBlock;
import gardensofthedead.block.SoulSporeBlock;
import gardensofthedead.feature.configuration.SoulSporeColumnConfiguration;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SoulSporeColumnFeature
extends Feature<SoulSporeColumnConfiguration> {
    public SoulSporeColumnFeature(Codec<SoulSporeColumnConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SoulSporeColumnConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        SoulSporeColumnConfiguration config = (SoulSporeColumnConfiguration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        if (!SoulSporeColumnFeature.isValidPlacementLocation((LevelAccessor)level, origin, config)) {
            return false;
        }
        Direction direction = config.direction();
        RandomSource randomSource = context.m_225041_();
        int length = config.length().m_214085_(randomSource);
        float glowingChance = config.glowingChance();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        SoulSporeColumnFeature.placeSoulSporeColumn((LevelAccessor)level, randomSource, pos, length, direction, glowingChance);
        return true;
    }

    public static void placeSoulSporeColumn(LevelAccessor level, RandomSource randomSource, BlockPos.MutableBlockPos pos, int length, Direction direction, float glowingChance) {
        for (int y = 1; y <= length; ++y) {
            if (level.m_46859_((BlockPos)pos)) {
                if (y == length || !level.m_46859_(pos.m_121945_(direction))) {
                    BlockState topState = randomSource.m_188501_() < glowingChance && y > 1 ? ((SoulSporeBaseBlock)((Object)ModBlocks.GLOWING_SOUL_SPORE.get())).m_49966_() : (BlockState)((SoulSporeBlock)((Object)ModBlocks.SOUL_SPORE.get())).m_49966_().m_61124_((Property)SoulSporeBlock.GROWING, (Comparable)Boolean.valueOf(false));
                    level.m_7731_((BlockPos)pos, (BlockState)topState.m_61124_((Property)SoulSporeBaseBlock.DIRECTION, (Comparable)direction), 2);
                    break;
                }
                BlockState state = (BlockState)((BlockState)((BlockState)((SoulSporeBlock)((Object)ModBlocks.SOUL_SPORE.get())).m_49966_().m_61124_((Property)SoulSporeBlock.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SoulSporeBaseBlock.DIRECTION, (Comparable)direction)).m_61124_((Property)SoulSporeBlock.GROWING, (Comparable)Boolean.valueOf(false));
                level.m_7731_((BlockPos)pos, state, 2);
            }
            pos.m_122173_(direction);
        }
    }

    private static boolean isValidPlacementLocation(LevelAccessor level, BlockPos pos, SoulSporeColumnConfiguration configuration) {
        if (level.m_46859_(pos)) {
            BlockState supportingState = level.m_8055_(pos.m_121945_(configuration.direction().m_122424_()));
            return supportingState.m_60713_(Blocks.f_50135_) || supportingState.m_60713_(Blocks.f_50136_);
        }
        return false;
    }
}

