/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.block;

import gardensofthedead.block.WhistlecaneBaseBlock;
import gardensofthedead.network.NetworkHandler;
import gardensofthedead.network.WhistleEffectPacket;
import gardensofthedead.registry.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WhistlecaneBlock
extends WhistlecaneBaseBlock {
    public static final BooleanProperty GROWING = BooleanProperty.m_61465_((String)"growing");
    public static final double GROW_CHANCE = 0.1;
    public static final double WHISTLE_CHANCE = 0.025;

    public WhistlecaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GROWING, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWING});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos updatedPos) {
        if (direction == Direction.UP && (newState.m_60713_(this.getHeadBlock()) || newState.m_60713_(this.getBodyBlock()))) {
            return this.getBodyBlock().m_49966_();
        }
        return super.m_7417_(state, direction, newState, level, pos, updatedPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        int height;
        if (((Boolean)state.m_61143_((Property)GROWING)).booleanValue() && level.m_46859_(pos.m_7494_()) && (height = this.getHeightBelowUpToMax((BlockGetter)level, pos) + 1) < 6 && (double)randomSource.m_188501_() < 0.1) {
            this.growCane((Level)level, pos, randomSource, height);
            return;
        }
        if ((double)randomSource.m_188501_() < 0.025 && level.m_46859_(pos.m_7494_())) {
            this.whistle(state, level, pos, randomSource);
        }
    }

    private void whistle(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Vec3 offset = state.m_60824_((BlockGetter)level, pos);
        double x = (double)pos.m_123341_() + offset.f_82479_ + 0.5;
        double z = (double)pos.m_123343_() + offset.f_82481_ + 0.5;
        double y = (double)pos.m_123342_() + offset.f_82480_ + 1.0;
        float volume = 1.0f;
        float pitch = randomSource.m_188501_() * 0.3f + 0.85f;
        level.m_6263_(null, x, y, z, (SoundEvent)ModSoundEvents.WHISTLECANE_WHISTLE.get(), SoundSource.BLOCKS, volume, pitch);
        this.sendWhistlePacket(level, pos);
    }

    private void sendWhistlePacket(ServerLevel level, BlockPos pos) {
        NetworkHandler.sendToTrackingPlayers(level, pos, new WhistleEffectPacket(pos, (Level)level));
    }
}

