/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.block;

import gardensofthedead.block.WhistlecaneBlock;
import gardensofthedead.platform.PlatformServices;
import gardensofthedead.registry.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class WhistlecaneBaseBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final int MAX_HEIGHT = 6;

    public WhistlecaneBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        return stateBelow.m_60713_(this.getBodyBlock()) || stateBelow.m_60713_(this.getHeadBlock()) || stateBelow.m_204336_(BlockTags.f_13077_) || stateBelow.m_60713_(Blocks.f_50135_) || stateBelow.m_60713_(Blocks.f_50136_);
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        int heightAbove = this.getHeightAboveUpToMax(level, pos);
        int heightBelow = this.getHeightBelowUpToMax(level, pos);
        BlockState topState = level.m_8055_(pos.m_6630_(heightAbove));
        return heightAbove + heightBelow + 1 < 6 && topState.m_60713_(this.getHeadBlock()) && (Boolean)topState.m_61143_((Property)WhistlecaneBlock.GROWING) != false;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        int heightAbove = this.getHeightAboveUpToMax((BlockGetter)level, pos);
        int heightBelow = this.getHeightBelowUpToMax((BlockGetter)level, pos);
        int height = heightAbove + heightBelow + 1;
        int extraHeight = 1 + randomSource.m_188503_(2);
        for (int blocksGrown = 0; blocksGrown < extraHeight; ++blocksGrown) {
            BlockPos grownPos = pos.m_6630_(heightAbove);
            BlockState grownState = level.m_8055_(grownPos);
            if (height >= 6 || !((Boolean)grownState.m_61143_((Property)WhistlecaneBlock.GROWING)).booleanValue() || !level.m_46859_(grownPos.m_7494_())) {
                return;
            }
            this.growCane((Level)level, grownPos, randomSource, height);
            ++heightAbove;
            ++height;
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (PlatformServices.platformHelper.isSword(player.m_21205_())) {
            return 1.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    protected void growCane(Level level, BlockPos pos, RandomSource randomSource, int currentHeight) {
        boolean continueGrowing = !(currentHeight >= 1 && randomSource.m_188501_() < (float)(6 - currentHeight) / 4.0f || currentHeight == 5);
        level.m_7731_(pos.m_7494_(), (BlockState)this.getHeadBlock().m_49966_().m_61124_((Property)WhistlecaneBlock.GROWING, (Comparable)Boolean.valueOf(continueGrowing)), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState above = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        return !above.m_60713_(this.getHeadBlock()) && !above.m_60713_(this.getBodyBlock()) ? this.getHeadBlock().m_49966_() : this.getBodyBlock().m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos updatedPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, newState, level, pos, updatedPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter level, BlockPos pos) {
        int height;
        for (height = 0; height < 6 && level.m_8055_(pos.m_6630_(height + 1)).m_60713_((Block)this); ++height) {
        }
        return height;
    }

    protected int getHeightBelowUpToMax(BlockGetter level, BlockPos pos) {
        int height;
        for (height = 0; height < 6 && level.m_8055_(pos.m_6625_(height + 1)).m_60713_((Block)this); ++height) {
        }
        return height;
    }

    protected Block getHeadBlock() {
        return (Block)ModBlocks.WHISTLECANE.get();
    }

    protected Block getBodyBlock() {
        return (Block)ModBlocks.WHISTLECANE_PLANT.get();
    }
}

