/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.feature;

import com.mojang.serialization.Codec;
import gardensofthedead.feature.SoulSporeColumnFeature;
import gardensofthedead.feature.configuration.HugeFlatFungusConfiguration;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;

public class HugeFlatFungusFeature
extends Feature<HugeFlatFungusConfiguration> {
    public HugeFlatFungusFeature(Codec<HugeFlatFungusConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeFlatFungusConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        ChunkGenerator chunkgenerator = context.m_159775_();
        HugeFlatFungusConfiguration configuration = (HugeFlatFungusConfiguration)context.m_159778_();
        Block validBaseBlock = configuration.validBaseState().m_60734_();
        BlockState supportingBlock = level.m_8055_(pos.m_7495_());
        if (!supportingBlock.m_60713_(validBaseBlock)) {
            return false;
        }
        int height = Mth.m_216271_((RandomSource)randomsource, (int)4, (int)9);
        if (!configuration.planted()) {
            int maxHeight = chunkgenerator.m_6331_();
            if (pos.m_123342_() + height + 1 >= maxHeight) {
                return false;
            }
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);
        this.placeStem((LevelAccessor)level, randomsource, configuration, pos, height);
        this.placeHat((LevelAccessor)level, randomsource, configuration, pos, height);
        return true;
    }

    private static boolean isReplaceable(LevelAccessor level, BlockPos pos, boolean isTrunk) {
        return level.m_7433_(pos, state -> {
            Material material = state.m_60767_();
            return state.m_60767_().m_76336_() || isTrunk && material == Material.f_76300_;
        });
    }

    private void placeStem(LevelAccessor level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos origin, int height) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState stemState = configuration.stemState();
        for (int y = 0; y < height; ++y) {
            pos.m_122154_((Vec3i)origin, 0, y, 0);
            if (!HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, true)) continue;
            level.m_7731_((BlockPos)pos, stemState, 3);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean placed;
                boolean isCorner;
                if (x == 0 && z == 0) continue;
                boolean bl = isCorner = x != 0 && z != 0;
                if (!isCorner && randomSource.m_188501_() <= 0.75f || isCorner && randomSource.m_188501_() < 0.25f) {
                    pos.m_122154_((Vec3i)origin, x, -1, z);
                    if (!level.m_46859_((BlockPos)pos)) {
                        pos.m_122173_(Direction.UP);
                        placed = this.tryPlaceStem(level, pos, configuration);
                        if (!isCorner && placed && randomSource.m_188501_() < 0.25f) {
                            pos.m_122154_((Vec3i)origin, x, 1, z);
                            this.tryPlaceStem(level, pos, configuration);
                        }
                    }
                }
                if (!(!isCorner && randomSource.m_188501_() <= 0.75f) && (!isCorner || !(randomSource.m_188501_() < 0.25f))) continue;
                pos.m_122154_((Vec3i)origin, x, height - 1, z);
                placed = this.tryPlaceStem(level, pos, configuration);
                if (height <= 4 || isCorner || !placed || !(randomSource.m_188501_() < 0.25f)) continue;
                pos.m_122154_((Vec3i)origin, x, height - 2, z);
                this.tryPlaceStem(level, pos, configuration);
            }
        }
    }

    private boolean tryPlaceStem(LevelAccessor level, BlockPos.MutableBlockPos pos, HugeFlatFungusConfiguration configuration) {
        if (HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, true)) {
            if (configuration.planted() && !level.m_8055_(pos.m_7495_()).m_60795_()) {
                level.m_46961_((BlockPos)pos, true);
            }
            level.m_7731_((BlockPos)pos, configuration.stemState(), 3);
            return true;
        }
        return false;
    }

    private void placeHat(LevelAccessor level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos origin, int height) {
        float wobbliness = 0.1f + randomSource.m_188501_() * 0.15f;
        float wobbleAngle = randomSource.m_188501_() * (float)Math.PI * 2.0f;
        float size = (6.0f + randomSource.m_188501_() * 3.0f) / 2.0f;
        int maxSize = Mth.m_14165_((double)((double)size * 1.25));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean placeGlowingSpores = randomSource.m_188501_() < 0.4f;
        for (int x = -maxSize; x <= maxSize; ++x) {
            for (int z = -maxSize; z <= maxSize; ++z) {
                boolean isEdge;
                float angle = x == 0 && z == 0 ? 0.0f : (float)Mth.m_14136_((double)x, (double)z);
                float wobble = 1.0f + wobbliness * Mth.m_14089_((float)(angle - wobbleAngle));
                float r = x * x + z * z;
                if (!(Mth.m_14207_((float)wobble) * r <= Mth.m_14207_((float)size))) continue;
                boolean bl = isEdge = (double)(Mth.m_14207_((float)wobble) * r) > Mth.m_144952_((double)((double)size - 1.5));
                if (isEdge) {
                    pos.m_122154_((Vec3i)origin, x, height - 1, z);
                } else {
                    pos.m_122154_((Vec3i)origin, x, height, z);
                }
                if (!HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, false)) continue;
                if (configuration.planted() && !level.m_8055_(pos.m_7495_()).m_60795_()) {
                    level.m_46961_((BlockPos)pos, true);
                }
                this.placeHatBlock(level, randomSource, configuration, pos, isEdge, placeGlowingSpores);
            }
        }
    }

    private void placeHatBlock(LevelAccessor level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos.MutableBlockPos pos, boolean isEdge, boolean placeGlowingSpores) {
        this.m_5974_((LevelWriter)level, (BlockPos)pos, configuration.hatState());
        float shroomlightChance = isEdge ? 0.0f : 0.05f;
        float hangingVineChance = isEdge ? 0.3f : 0.75f;
        float sproutChance = 0.2f;
        if (randomSource.m_188501_() < shroomlightChance) {
            if (level.m_46859_(pos.m_7495_())) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_50701_.m_49966_());
            }
        } else if (randomSource.m_188501_() < hangingVineChance) {
            HugeFlatFungusFeature.tryPlaceHangingSoulSpore((BlockPos)pos, level, randomSource, isEdge, placeGlowingSpores);
        }
        if (randomSource.m_188501_() < sproutChance && level.m_46859_(pos.m_7494_())) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), ((Block)ModBlocks.SOULBLIGHT_SPROUTS.get()).m_49966_());
        }
    }

    private static void tryPlaceHangingSoulSpore(BlockPos pos, LevelAccessor level, RandomSource randomSource, boolean isEdge, boolean placeGlowingSpores) {
        BlockPos.MutableBlockPos below = pos.m_122032_().m_122173_(Direction.DOWN);
        if (level.m_46859_((BlockPos)below)) {
            int length = Mth.m_216271_((RandomSource)randomSource, (int)2, (int)3) + (isEdge ? 0 : 1);
            SoulSporeColumnFeature.placeSoulSporeColumn(level, randomSource, below, length, Direction.DOWN, isEdge && placeGlowingSpores ? 1.0f : 0.0f);
        }
    }
}

