/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EmergencyItemsScreen
extends BaseScreen {
    private final long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public EmergencyItemsScreen() {
        this.endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.emergencyItemsCooldown * 1000L;
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, (Component)Component.m_237115_((String)"gui.cancel"), (Icon)Color4I.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((Component)Component.m_237115_((String)"gui.close"));
                new GetEmergencyItemsMessage().sendToServer();
            }
            left = 0L;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((int)((double)w / 2.0)), (double)((int)((double)h / 5.0)), 0.0);
        matrixStack.m_85841_(2.0f, 2.0f, 1.0f);
        String s = I18n.m_118938_((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(matrixStack, (Object)s, (float)(-theme.getStringWidth(s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((int)((double)w / 2.0)), (double)((int)((double)h / 2.5)), 0.0);
        matrixStack.m_85841_(4.0f, 4.0f, 1.0f);
        s = left <= 0L ? "00:00" : TimeUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(matrixStack, (Object)s, (float)(x1 - 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)(x1 + 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, -1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 0.0f, Color4I.WHITE, 0);
        matrixStack.m_85849_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final ItemStack stack;

        public EmergencyItem(Panel p, ItemStack is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, list1);
            for (Component t : list1) {
                list.add(t);
            }
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get((String)"rsquare").outline.draw(matrixStack, x - 3, y - 3, w + 6, h + 6);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((PoseStack)matrixStack, (ItemStack)this.stack, (int)0, (boolean)true, null);
            matrixStack.m_85849_();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.stack;
        }
    }
}

