/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.util.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class MagicalFarmlandLootModifier
extends LootModifier {
    public static final Supplier<Codec<MagicalFarmlandLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> MagicalFarmlandLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MagicalFarmlandLootModifier::new)));

    public MagicalFarmlandLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        Vec3 pos = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        ServerLevel level = context.m_78952_();
        if (state == null || pos == null || !state.m_204336_(BlockTags.f_13073_) || state.m_204336_(ModTags.Blocks.MAGICAL_FARMLAND_BLACKLISTED)) {
            return generatedLoot;
        }
        if (level.m_8055_(new BlockPos(pos).m_7495_()).m_60713_((Block)ModBlocks.MAGICAL_FARMLAND.get())) {
            CropBlock crop;
            Block block = state.m_60734_();
            if (block instanceof CropBlock && !(crop = (CropBlock)block).m_52307_(state)) {
                return generatedLoot;
            }
            generatedLoot.addAll(generatedLoot.stream().filter(stack -> !stack.m_204117_(ModTags.Items.MAGICAL_FARMLAND_BLACKLISTED)).toList());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

