/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoul;
import com.stal111.forbidden_arcanus.core.config.AurealConfig;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class DeathEvents {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        RandomSource random = entity.m_217043_();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player && !((player = (Player)entity2) instanceof FakePlayer)) {
            this.increaseCorruption(player, entity, random);
            this.spawnLostSoul(entity, random);
        }
    }

    private void increaseCorruption(Player player, LivingEntity entity, RandomSource random) {
        MobCategory category = entity.m_6095_().m_20674_();
        if (category == MobCategory.AMBIENT || category == MobCategory.CREATURE) {
            boolean aurealEntity = entity.getPersistentData().m_128471_("aureal");
            double chance = aurealEntity ? (Double)AurealConfig.AUREAL_ENTITY_DEATH_INCREASEMENT_CHANCE.get() : (Double)AurealConfig.ENTITY_DEATH_INCREASEMENT_CHANCE.get();
            int amount = aurealEntity ? (Integer)AurealConfig.AUREAL_ENTITY_DEATH_INCREASEMENT_AMOUNT.get() : (Integer)AurealConfig.ENTITY_DEATH_INCREASEMENT_AMOUNT.get();
            if (random.m_188500_() < chance) {
                AurealHelper.increaseCorruption(player, amount);
            }
        }
    }

    private void spawnLostSoul(LivingEntity entity, RandomSource random) {
        EntityType type = entity.m_6095_();
        Level level = entity.m_9236_();
        double chance = 0.05;
        if (type.m_204039_(ModTags.EntityTypes.SPAWNS_LOST_SOUL_CHANCE) && random.m_188500_() < chance) {
            level.m_7967_((Entity)new LostSoul(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
        } else if (type.m_204039_(ModTags.EntityTypes.SPAWNS_CORRUPT_LOST_SOUL_CHANCE) && random.m_188500_() < chance) {
            LostSoul lostSoul = new LostSoul(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            lostSoul.setVariant(LostSoul.Variant.CORRUPT_LOST_SOUL);
            level.m_7967_((Entity)lostSoul);
        }
    }
}

