/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.MagicCircle;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.EssenceManager;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.common.inventory.HephaestusForgeMenu;
import com.stal111.forbidden_arcanus.common.inventory.InputType;
import com.stal111.forbidden_arcanus.common.inventory.input.HephaestusForgeInput;
import com.stal111.forbidden_arcanus.common.inventory.input.HephaestusForgeInputs;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateItemInSlotPacket;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HephaestusForgeBlockEntity
extends BaseContainerBlockEntity {
    private final NonNullList<ItemStack> inventoryContents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final ContainerData hephaestusForgeData;
    private final RitualManager ritualManager = new RitualManager(this);
    private final EssenceManager essenceManager = new EssenceManager(this);
    private final MagicCircle magicCircle = new MagicCircle(this.ritualManager);
    private HephaestusForgeLevel forgeLevel = HephaestusForgeLevel.ONE;
    private List<LivingEntity> entities = new ArrayList<LivingEntity>();
    private int displayCounter;

    public HephaestusForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get(), pos, state);
        this.hephaestusForgeData = new ContainerData(){

            public int m_6413_(int index) {
                EssenceManager manager = HephaestusForgeBlockEntity.this.getEssenceManager();
                return switch (index) {
                    case 0 -> manager.getLevel().getIndex();
                    case 1 -> manager.getAureal();
                    case 2 -> manager.getCorruption();
                    case 3 -> manager.getSouls();
                    case 4 -> manager.getBlood();
                    case 5 -> manager.getExperience();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                EssenceManager manager = HephaestusForgeBlockEntity.this.getEssenceManager();
                switch (index) {
                    case 0: {
                        HephaestusForgeBlockEntity.this.setLevel(HephaestusForgeLevel.getFromIndex(value));
                        break;
                    }
                    case 1: {
                        manager.setAureal(value);
                        break;
                    }
                    case 2: {
                        manager.setCorruption(value);
                        break;
                    }
                    case 3: {
                        manager.setSouls(value);
                        break;
                    }
                    case 4: {
                        manager.setBlood(value);
                        break;
                    }
                    case 5: {
                        manager.setExperience(value);
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HephaestusForgeBlockEntity blockEntity) {
        blockEntity.magicCircle.tick();
        ++blockEntity.displayCounter;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HephaestusForgeBlockEntity blockEntity) {
        for (int i = 5; i <= 8; ++i) {
            HephaestusForgeInput input;
            InputType inputType;
            ItemStack stack = (ItemStack)blockEntity.inventoryContents.get(i);
            if (stack.m_41619_() || (inputType = blockEntity.getInputTypeFromSlot(i)) == null || (input = blockEntity.getInput(stack, inputType)) == null) continue;
            blockEntity.fillWith(inputType, stack, input, i);
            blockEntity.m_6596_();
        }
        if (level.m_46467_() % 80L == 0L) {
            ((HephaestusForgeBlock)state.m_60734_()).updateState(state, level, pos);
        }
        if (level.m_46467_() % 20L == 0L) {
            blockEntity.entities = level.m_45976_(LivingEntity.class, new AABB(pos).m_82377_(5.0, 5.0, 5.0));
            blockEntity.essenceManager.tick();
        }
        blockEntity.ritualManager.tick((ServerLevel)level, pos);
    }

    private InputType getInputTypeFromSlot(int slot) {
        return switch (slot) {
            case 5 -> InputType.AUREAL;
            case 6 -> InputType.SOULS;
            case 7 -> InputType.BLOOD;
            case 8 -> InputType.EXPERIENCE;
            default -> null;
        };
    }

    @Nullable
    private HephaestusForgeInput getInput(ItemStack stack, InputType inputType) {
        if (this.isTypeFull(inputType)) {
            return null;
        }
        return HephaestusForgeInputs.getInputs().stream().filter(input -> input.canInput(inputType, stack)).findFirst().orElse(null);
    }

    private boolean isTypeFull(InputType inputType) {
        HephaestusForgeLevel level = this.getForgeLevel();
        EssenceManager manager = this.getEssenceManager();
        return switch (inputType) {
            default -> throw new IncompatibleClassChangeError();
            case InputType.AUREAL -> {
                if (manager.getAureal() >= level.getMaxAureal()) {
                    yield true;
                }
                yield false;
            }
            case InputType.SOULS -> {
                if (manager.getSouls() >= level.getMaxSouls()) {
                    yield true;
                }
                yield false;
            }
            case InputType.BLOOD -> {
                if (manager.getBlood() >= level.getMaxBlood()) {
                    yield true;
                }
                yield false;
            }
            case InputType.EXPERIENCE -> manager.getExperience() >= level.getMaxExperience();
        };
    }

    public HephaestusForgeLevel getForgeLevel() {
        return this.forgeLevel;
    }

    public void setLevel(HephaestusForgeLevel level) {
        this.forgeLevel = level;
    }

    public ContainerData getHephaestusForgeData() {
        return this.hephaestusForgeData;
    }

    public EssenceManager getEssenceManager() {
        return this.essenceManager;
    }

    public MagicCircle getMagicCircle() {
        return this.magicCircle;
    }

    public List<LivingEntity> getEntities() {
        return this.entities;
    }

    public void fillWith(InputType inputType, ItemStack stack, HephaestusForgeInput input, int slot) {
        int value = input.getInputValue(inputType, stack, Objects.requireNonNull(this.m_58904_()).m_213780_());
        EssenceManager manager = this.getEssenceManager();
        switch (inputType) {
            case AUREAL: {
                manager.increaseAureal(value);
                break;
            }
            case SOULS: {
                manager.increaseSouls(value);
                break;
            }
            case BLOOD: {
                manager.increaseBlood(value);
                break;
            }
            case EXPERIENCE: {
                manager.increaseExperience(value);
            }
        }
        input.finishInput(inputType, stack, this, slot, value);
    }

    public RitualManager getRitualManager() {
        return this.ritualManager;
    }

    public int getDisplayCounter() {
        return this.displayCounter;
    }

    public void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Level", this.getForgeLevel().getName());
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventoryContents);
        tag.m_128365_("Ritual", (Tag)this.getRitualManager().save(new CompoundTag()));
        tag.m_128365_("Essences", (Tag)this.getEssenceManager().save(new CompoundTag()));
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.setLevel(HephaestusForgeLevel.getFromName(tag.m_128461_("Level")));
        this.inventoryContents.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventoryContents);
        this.getRitualManager().load(tag.m_128469_("Ritual"));
        this.getEssenceManager().load(tag.m_128469_("Essences"));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        AABB boundingBox = new AABB(this.m_58899_()).m_82363_(0.0, 1.0, 0.0);
        if (this.getRitualManager().isRitualActive()) {
            boundingBox = boundingBox.m_82377_(2.5, 0.0, 2.5);
        }
        return boundingBox;
    }

    @Nonnull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.forbidden_arcanus.hephaestus_forge");
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int containerId, @Nonnull Inventory inventory) {
        return new HephaestusForgeMenu(containerId, (Container)this, this.getHephaestusForgeData(), inventory);
    }

    public int m_6643_() {
        return this.inventoryContents.size();
    }

    public boolean m_7983_() {
        return this.inventoryContents.stream().allMatch(ItemStack::m_41619_);
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.inventoryContents, (int)index, (int)count);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventoryContents, (int)index);
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 4 && this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            BlockPos pos = this.m_58899_();
            NetworkHandler.sendToTrackingChunk(this.m_58904_().m_46745_(pos), new UpdateItemInSlotPacket(pos, stack, 4));
        }
        this.m_6596_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventoryContents.clear();
    }
}

