/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tooltip
extends GuiComponent
implements Widget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected Font font;
    protected List<Component> textLines;
    protected int width;
    protected int height;
    protected int aspectWidth;
    protected int aspectHeight;
    protected Integer x;
    protected Integer y;
    protected int textBorderSize;
    protected int mouseOffset;
    protected ITexture backgroundTexture;
    protected DrawableColor backgroundColor;
    protected DrawableColor borderColor;
    protected boolean vanillaLike;
    protected boolean keepBackgroundAspectRatio;
    protected boolean textShadow;
    protected TooltipTextAlignment textAlignment;
    protected DrawableColor textBaseColor;
    protected Float scale;

    public Tooltip() {
        this.font = Minecraft.m_91087_().f_91062_;
        this.textLines = new ArrayList<Component>();
        this.width = 0;
        this.height = 0;
        this.aspectWidth = -1;
        this.aspectHeight = -1;
        this.x = null;
        this.y = null;
        this.textBorderSize = 5;
        this.mouseOffset = 12;
        this.backgroundTexture = null;
        this.backgroundColor = null;
        this.borderColor = null;
        this.vanillaLike = true;
        this.keepBackgroundAspectRatio = true;
        this.textShadow = true;
        this.textAlignment = TooltipTextAlignment.LEFT;
        this.textBaseColor = null;
        this.scale = null;
    }

    @NotNull
    public static Tooltip empty() {
        return new Tooltip();
    }

    @NotNull
    public static Tooltip of(String ... tooltip) {
        Tooltip t = new Tooltip();
        if (tooltip != null) {
            t.setTooltipText(tooltip);
        }
        return t;
    }

    @NotNull
    public static Tooltip of(Component ... tooltip) {
        Tooltip t = new Tooltip();
        if (tooltip != null) {
            t.setTooltipText(tooltip);
        }
        return t;
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (!this.isEmpty() && s != null) {
            this.updateAspectRatio();
            int x = this.calculateX(s, mouseX);
            int y = this.calculateY(s, mouseY);
            RenderSystem.m_69478_();
            pose.m_85836_();
            float scale = 1.0f;
            if (this.scale != null) {
                scale = UIBase.calculateFixedScale(this.scale.floatValue());
                pose.m_85841_(scale, scale, scale);
            }
            pose.m_85837_(0.0, 0.0, (double)(600.0f / scale));
            RenderSystem.m_69482_();
            RenderingUtils.resetShaderColor();
            this.renderBackground(pose, x, y);
            this.renderTextLines(pose, x, y);
            RenderSystem.m_69465_();
            pose.m_85849_();
            RenderingUtils.resetShaderColor();
        }
    }

    protected void renderTextLines(PoseStack pose, int x, int y) {
        int yLine = y;
        for (Component c : this.textLines) {
            int w = this.font.m_92852_((FormattedText)c);
            int x2 = x + this.textBorderSize;
            int y2 = yLine + this.textBorderSize;
            if (this.textAlignment == TooltipTextAlignment.RIGHT) {
                int diff = Math.max(0, x + this.getWidth() - this.textBorderSize - (x2 + w));
                x2 += diff;
            }
            if (this.textAlignment == TooltipTextAlignment.CENTERED) {
                x2 = x + Math.max(0, this.getWidth() / 2 - w / 2);
            }
            if (this.hasTextShadow()) {
                this.font.m_92763_(pose, c, (float)x2, (float)y2, this.textBaseColor != null ? this.textBaseColor.getColorInt() : -1);
            } else {
                this.font.m_92889_(pose, c, (float)x2, (float)y2, this.textBaseColor != null ? this.textBaseColor.getColorInt() : -1);
            }
            Objects.requireNonNull(this.font);
            yLine += 9 + 2;
        }
    }

    protected void renderBackground(PoseStack pose, int x, int y) {
        if (this.vanillaLike || this.backgroundTexture == null && this.backgroundColor == null) {
            this.renderVanillaLikeBackground(pose, x, y, this.getWidth(), this.getHeight());
        } else if (this.backgroundTexture != null) {
            ResourceLocation loc = this.backgroundTexture.getResourceLocation();
            if (loc != null) {
                RenderUtils.bindTexture((ResourceLocation)loc);
                Tooltip.m_93133_((PoseStack)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (int)this.getWidth(), (int)this.getHeight());
            }
        } else if (this.borderColor != null) {
            Tooltip.m_93172_((PoseStack)pose, (int)(x + 1), (int)(y + 1), (int)(x + this.getWidth() - 1), (int)(y + this.getHeight() - 1), (int)this.backgroundColor.getColorInt());
            Tooltip.m_93172_((PoseStack)pose, (int)(x + 1), (int)y, (int)(x + this.getWidth() - 1), (int)(y + 1), (int)this.borderColor.getColorInt());
            Tooltip.m_93172_((PoseStack)pose, (int)(x + 1), (int)(y + this.getHeight() - 1), (int)(x + this.getWidth() - 1), (int)(y + this.getHeight()), (int)this.borderColor.getColorInt());
            Tooltip.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + 1), (int)(y + this.getHeight()), (int)this.borderColor.getColorInt());
            Tooltip.m_93172_((PoseStack)pose, (int)(x + this.getWidth() - 1), (int)y, (int)(x + this.getWidth()), (int)(y + this.getHeight()), (int)this.borderColor.getColorInt());
        } else {
            Tooltip.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + this.getWidth()), (int)(y + this.getHeight()), (int)this.backgroundColor.getColorInt());
        }
    }

    protected void renderVanillaLikeBackground(PoseStack pose, int x, int y, int width, int height) {
        pose.m_85836_();
        ShaderInstance shaderInstance = RenderSystem.m_157196_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f2 = pose.m_85850_().m_85861_();
        int z = 0;
        TooltipBackgroundRenderer.render((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> GuiComponent.m_93123_((Matrix4f)x$0, (BufferBuilder)x$1, (int)x$2, (int)x$3, (int)x$4, (int)x$5, (int)x$6, (int)x$7, (int)x$8), matrix4f2, builder, x, y, width, height, z);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        if (shaderInstance != null) {
            RenderSystem.m_157427_(() -> shaderInstance);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderingUtils.resetShaderColor();
        pose.m_85849_();
    }

    protected int calculateX(Screen screen, int mouseX) {
        float scale = 1.0f;
        if (this.scale != null) {
            scale = UIBase.calculateFixedScale(this.scale.floatValue());
        }
        if (this.x != null) {
            mouseX = this.x;
        }
        int width = this.getWidth();
        if (this.vanillaLike) {
            width += 4;
        }
        int scaledWidth = (int)((float)width * scale);
        int scaledMouseX = (int)((float)mouseX / scale) + this.mouseOffset;
        int scaledScreenWidth = (int)((float)screen.f_96543_ / scale);
        int x = mouseX + this.mouseOffset;
        if (x + scaledWidth > screen.f_96543_) {
            int offset = x + scaledWidth - screen.f_96543_;
            x -= offset;
        }
        return (int)((float)x / scale);
    }

    protected int calculateY(Screen screen, int mouseY) {
        float scale = 1.0f;
        if (this.scale != null) {
            scale = UIBase.calculateFixedScale(this.scale.floatValue());
        }
        if (this.y != null) {
            mouseY = this.y;
        }
        int height = this.getHeight();
        if (this.vanillaLike) {
            height += 4;
        }
        int scaledHeight = (int)((float)height * scale);
        int scaledMouseY = (int)((float)mouseY / scale) + this.mouseOffset;
        int scaledScreenHeight = (int)((float)screen.f_96544_ / scale);
        int y = mouseY + this.mouseOffset;
        if (y + scaledHeight > screen.f_96544_) {
            int offset = y + scaledHeight - screen.f_96544_;
            y -= offset;
        }
        return (int)((float)y / scale);
    }

    protected int getWidth() {
        if (this.aspectWidth != -1) {
            return this.aspectWidth;
        }
        return this.width;
    }

    protected int getHeight() {
        if (this.aspectHeight != -1) {
            return this.aspectHeight;
        }
        return this.height;
    }

    protected void updateAspectRatio() {
        if (!this.keepBackgroundAspectRatio || this.backgroundTexture == null) {
            this.aspectWidth = -1;
            this.aspectHeight = -1;
            return;
        }
        int[] size = this.backgroundTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.width, this.height);
        this.aspectWidth = size[0];
        this.aspectHeight = size[1];
    }

    protected void updateSize() {
        int w = 0;
        int h = 0;
        for (Component c : this.textLines) {
            int wl = this.font.m_92852_((FormattedText)c);
            if (wl > w) {
                w = wl;
            }
            Objects.requireNonNull(this.font);
            h += 9 + 2;
        }
        if (h > 0) {
            h -= 2;
        }
        this.width = w + this.textBorderSize * 2;
        this.height = h + this.textBorderSize * 2;
    }

    public boolean isEmpty() {
        return this.textLines.isEmpty();
    }

    public Tooltip setTooltipText(String ... lines) {
        ArrayList<Component> l = new ArrayList<Component>();
        if (lines != null) {
            for (String s : lines) {
                l.add((Component)Components.literal(s));
            }
        }
        return this.setTooltipText(l);
    }

    public Tooltip setTooltipText(Component ... lines) {
        return this.setTooltipText(lines != null ? Arrays.asList(lines) : null);
    }

    public Tooltip setTooltipText(List<Component> lines) {
        this.textLines = lines != null ? lines : new ArrayList();
        this.updateSize();
        return this;
    }

    public List<Component> getTooltip() {
        return new ArrayList<Component>(this.textLines);
    }

    public Tooltip setTextBorderSize(int size) {
        this.textBorderSize = size;
        this.updateSize();
        return this;
    }

    public int getTextBorderSize() {
        return this.textBorderSize;
    }

    public Tooltip setMouseOffset(int offset) {
        this.mouseOffset = offset;
        return this;
    }

    public int getMouseOffset() {
        return this.mouseOffset;
    }

    public Tooltip setBackgroundTexture(@NotNull ITexture texture) {
        this.backgroundTexture = texture;
        this.backgroundColor = null;
        this.vanillaLike = false;
        return this;
    }

    @Nullable
    public ITexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public Tooltip setBackgroundColor(@NotNull DrawableColor backgroundColor, @Nullable DrawableColor borderColor) {
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.backgroundTexture = null;
        this.vanillaLike = false;
        return this;
    }

    public Tooltip setDefaultStyle() {
        this.setTextShadow(FancyMenu.getOptions().enableUiTextShadow.getValue());
        this.setTextBaseColor(UIBase.getUIColorTheme().element_label_color_normal);
        return this.setBackgroundColor(UIBase.getUIColorTheme().element_background_color_normal, UIBase.getUIColorTheme().element_border_color_normal);
    }

    @Nullable
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nullable
    public DrawableColor getBorderColor() {
        return this.borderColor;
    }

    public Tooltip setVanillaLike(boolean vanillaLike) {
        this.vanillaLike = vanillaLike;
        this.backgroundColor = null;
        this.backgroundTexture = null;
        return this;
    }

    public boolean isVanillaLike() {
        return this.vanillaLike;
    }

    public Tooltip setKeepBackgroundAspectRatio(boolean keepBackgroundAspectRatio) {
        this.keepBackgroundAspectRatio = keepBackgroundAspectRatio;
        return this;
    }

    public boolean keepBackgroundAspectRatio() {
        return this.keepBackgroundAspectRatio;
    }

    public Tooltip setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public Tooltip setTextAlignment(TooltipTextAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    public TooltipTextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public Tooltip setTextBaseColor(@Nullable DrawableColor textBaseColor) {
        this.textBaseColor = textBaseColor;
        return this;
    }

    @Nullable
    public DrawableColor getTextBaseColor() {
        return this.textBaseColor;
    }

    public Tooltip setFont(Font font) {
        this.font = font != null ? font : Minecraft.m_91087_().f_91062_;
        this.updateSize();
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public Tooltip copyStyleOf(Tooltip tooltip) {
        this.borderColor = tooltip.borderColor;
        this.backgroundColor = tooltip.backgroundColor;
        this.backgroundTexture = tooltip.backgroundTexture;
        this.keepBackgroundAspectRatio = tooltip.keepBackgroundAspectRatio;
        this.vanillaLike = tooltip.vanillaLike;
        this.textBorderSize = tooltip.textBorderSize;
        this.textAlignment = tooltip.textAlignment;
        this.textShadow = tooltip.textShadow;
        this.textBaseColor = tooltip.textBaseColor;
        this.font = tooltip.font;
        return this;
    }

    public Tooltip setCustomX(@Nullable Integer x) {
        this.x = x;
        return this;
    }

    @Nullable
    public Integer getCustomX() {
        return this.x;
    }

    public Tooltip setCustomY(@Nullable Integer y) {
        this.y = y;
        return this;
    }

    @Nullable
    public Integer getCustomY() {
        return this.y;
    }

    @Nullable
    public Float getScale() {
        return this.scale;
    }

    public Tooltip setScale(@Nullable Float scale) {
        this.scale = scale;
        return this;
    }

    public static enum TooltipTextAlignment {
        LEFT,
        RIGHT,
        CENTERED;

    }

    public static class TooltipBackgroundRenderer {
        public static void render(Painter painter, Matrix4f matrix4f, BufferBuilder builder, int $$3, int $$4, int $$5, int $$6, int $$7) {
            int $$8 = $$3 - 3;
            int $$9 = $$4 - 3;
            int $$10 = $$5 + 3 + 3;
            int $$11 = $$6 + 3 + 3;
            TooltipBackgroundRenderer.renderHorizontalLine(painter, matrix4f, builder, $$8, $$9 - 1, $$10, $$7, -267386864);
            TooltipBackgroundRenderer.renderHorizontalLine(painter, matrix4f, builder, $$8, $$9 + $$11, $$10, $$7, -267386864);
            TooltipBackgroundRenderer.renderRectangle(painter, matrix4f, builder, $$8, $$9, $$10, $$11, $$7, -267386864);
            TooltipBackgroundRenderer.renderVerticalLine(painter, matrix4f, builder, $$8 - 1, $$9, $$11, $$7, -267386864);
            TooltipBackgroundRenderer.renderVerticalLine(painter, matrix4f, builder, $$8 + $$10, $$9, $$11, $$7, -267386864);
            TooltipBackgroundRenderer.renderFrameGradient(painter, matrix4f, builder, $$8, $$9 + 1, $$10, $$11, $$7, 0x505000FF, 1344798847);
        }

        private static void renderFrameGradient(Painter $$0, Matrix4f $$1, BufferBuilder $$2, int $$3, int $$4, int $$5, int $$6, int $$7, int $$8, int $$9) {
            TooltipBackgroundRenderer.renderVerticalLineGradient($$0, $$1, $$2, $$3, $$4, $$6 - 2, $$7, $$8, $$9);
            TooltipBackgroundRenderer.renderVerticalLineGradient($$0, $$1, $$2, $$3 + $$5 - 1, $$4, $$6 - 2, $$7, $$8, $$9);
            TooltipBackgroundRenderer.renderHorizontalLine($$0, $$1, $$2, $$3, $$4 - 1, $$5, $$7, $$8);
            TooltipBackgroundRenderer.renderHorizontalLine($$0, $$1, $$2, $$3, $$4 - 1 + $$6 - 1, $$5, $$7, $$9);
        }

        private static void renderVerticalLine(Painter $$0, Matrix4f $$1, BufferBuilder $$2, int $$3, int $$4, int $$5, int $$6, int $$7) {
            $$0.blit($$1, $$2, $$3, $$4, $$3 + 1, $$4 + $$5, $$6, $$7, $$7);
        }

        private static void renderVerticalLineGradient(Painter $$0, Matrix4f $$1, BufferBuilder $$2, int $$3, int $$4, int $$5, int $$6, int $$7, int $$8) {
            $$0.blit($$1, $$2, $$3, $$4, $$3 + 1, $$4 + $$5, $$6, $$7, $$8);
        }

        private static void renderHorizontalLine(Painter $$0, Matrix4f $$1, BufferBuilder $$2, int $$3, int $$4, int $$5, int $$6, int $$7) {
            $$0.blit($$1, $$2, $$3, $$4, $$3 + $$5, $$4 + 1, $$6, $$7, $$7);
        }

        private static void renderRectangle(Painter $$0, Matrix4f $$1, BufferBuilder $$2, int $$3, int $$4, int $$5, int $$6, int $$7, int $$8) {
            $$0.blit($$1, $$2, $$3, $$4, $$3 + $$5, $$4 + $$6, $$7, $$8, $$8);
        }

        @FunctionalInterface
        public static interface Painter {
            public void blit(Matrix4f var1, BufferBuilder var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
        }
    }
}

