/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorTheme;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorThemeRegistry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1.ExtendedSliderButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.AbstractExtendedSlider;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class UIBase
extends RenderingUtils {
    public static final int ELEMENT_BORDER_THICKNESS = 1;
    public static final int VERTICAL_SCROLL_BAR_WIDTH = 5;
    public static final int VERTICAL_SCROLL_BAR_HEIGHT = 40;
    public static final int HORIZONTAL_SCROLL_BAR_WIDTH = 40;
    public static final int HORIZONTAL_SCROLL_BAR_HEIGHT = 5;

    public static <T> T applyDefaultWidgetSkinTo(T widget) {
        if (widget instanceof ExtendedButton) {
            ExtendedButton e = (ExtendedButton)widget;
            return (T)UIBase.applyDefaultButtonSkinTo(e);
        }
        if (widget instanceof ExtendedEditBox) {
            ExtendedEditBox e = (ExtendedEditBox)widget;
            return (T)UIBase.applyDefaultEditBoxSkinTo(e);
        }
        if (widget instanceof EditBoxSuggestions) {
            EditBoxSuggestions s = (EditBoxSuggestions)((Object)widget);
            return (T)((Object)UIBase.applyDefaultEditBoxSuggestionsSkinTo(s));
        }
        if (widget instanceof ExtendedSliderButton) {
            ExtendedSliderButton s = (ExtendedSliderButton)widget;
            return (T)UIBase.applyDefaultSliderSkinTo(s);
        }
        if (widget instanceof AbstractExtendedSlider) {
            AbstractExtendedSlider s = (AbstractExtendedSlider)widget;
            return (T)UIBase.applyDefaultV2SliderSkinTo(s);
        }
        return widget;
    }

    private static ExtendedSliderButton applyDefaultSliderSkinTo(ExtendedSliderButton slider) {
        slider.setBackgroundColor(UIBase.getUIColorTheme().element_background_color_normal);
        slider.setBorderColor(UIBase.getUIColorTheme().element_border_color_normal);
        slider.setHandleColorNormal(UIBase.getUIColorTheme().slider_handle_color_normal);
        slider.setHandleColorHover(UIBase.getUIColorTheme().slider_handle_color_hover);
        slider.setLabelColorNormal(UIBase.getUIColorTheme().element_label_color_normal);
        slider.setLabelColorInactive(UIBase.getUIColorTheme().element_label_color_inactive);
        slider.setLabelShadow(FancyMenu.getOptions().enableUiTextShadow.getValue());
        return slider;
    }

    private static AbstractExtendedSlider applyDefaultV2SliderSkinTo(AbstractExtendedSlider slider) {
        slider.setSliderBackgroundColorNormal(UIBase.getUIColorTheme().element_background_color_normal);
        slider.setSliderBorderColorNormal(UIBase.getUIColorTheme().element_border_color_normal);
        slider.setSliderHandleColorNormal(UIBase.getUIColorTheme().slider_handle_color_normal);
        slider.setSliderHandleColorHover(UIBase.getUIColorTheme().slider_handle_color_hover);
        slider.setLabelColorNormal(UIBase.getUIColorTheme().element_label_color_normal);
        slider.setLabelColorInactive(UIBase.getUIColorTheme().element_label_color_inactive);
        slider.setLabelShadow(FancyMenu.getOptions().enableUiTextShadow.getValue());
        return slider;
    }

    private static EditBoxSuggestions applyDefaultEditBoxSuggestionsSkinTo(EditBoxSuggestions editBoxSuggestions) {
        editBoxSuggestions.setBackgroundColor(UIBase.getUIColorTheme().suggestions_background_color);
        editBoxSuggestions.setNormalTextColor(UIBase.getUIColorTheme().suggestions_text_color_normal);
        editBoxSuggestions.setSelectedTextColor(UIBase.getUIColorTheme().suggestions_text_color_selected);
        editBoxSuggestions.setTextShadow(FancyMenu.getOptions().enableUiTextShadow.getValue());
        return editBoxSuggestions;
    }

    private static ExtendedEditBox applyDefaultEditBoxSkinTo(ExtendedEditBox editBox) {
        UIColorTheme theme = UIBase.getUIColorTheme();
        editBox.setTextColor(theme.edit_box_text_color_normal);
        editBox.setTextColorUneditable(theme.edit_box_text_color_uneditable);
        editBox.setBackgroundColor(theme.edit_box_background_color);
        editBox.setBorderNormalColor(theme.edit_box_border_color_normal);
        editBox.setBorderFocusedColor(theme.edit_box_border_color_focused);
        editBox.setSuggestionTextColor(theme.edit_box_suggestion_text_color);
        editBox.setTextShadow(false);
        return editBox;
    }

    private static ExtendedButton applyDefaultButtonSkinTo(ExtendedButton button) {
        button.setBackgroundColorNormal(UIBase.getUIColorTheme().element_background_color_normal);
        button.setBackgroundColorHover(UIBase.getUIColorTheme().element_background_color_hover);
        button.setBackgroundColorInactive(UIBase.getUIColorTheme().element_background_color_normal);
        button.setBorderColorNormal(UIBase.getUIColorTheme().element_border_color_normal);
        button.setBorderColorHover(UIBase.getUIColorTheme().element_border_color_hover);
        button.setBorderColorInactive(UIBase.getUIColorTheme().element_border_color_normal);
        button.setLabelBaseColorNormal(UIBase.getUIColorTheme().element_label_color_normal);
        button.setLabelBaseColorInactive(UIBase.getUIColorTheme().element_label_color_inactive);
        button.setLabelShadowEnabled(FancyMenu.getOptions().enableUiTextShadow.getValue());
        button.setForceDefaultTooltipStyle(true);
        return button;
    }

    public static float getUIScale() {
        float uiScale = FancyMenu.getOptions().uiScale.getValue().floatValue();
        if (uiScale == 4.0f) {
            uiScale = 1.0f;
            if (Minecraft.m_91087_().m_91268_().m_85441_() > 1920 || Minecraft.m_91087_().m_91268_().m_85442_() > 1080) {
                uiScale = 2.0f;
            }
        }
        if (Minecraft.m_91087_().m_91390_() && uiScale < 2.0f) {
            uiScale = 2.0f;
        }
        return uiScale;
    }

    public static float getFixedUIScale() {
        return UIBase.calculateFixedScale(UIBase.getUIScale());
    }

    public static float calculateFixedScale(float fixedScale) {
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        return (float)(1.0 * (1.0 / guiScale) * (double)fixedScale);
    }

    public static void renderListingDot(PoseStack matrix, float x, float y, int color) {
        UIBase.fillF(matrix, x, y, x + 4.0f, y + 4.0f, color);
    }

    public static void renderListingDot(PoseStack matrix, int x, int y, Color color) {
        UIBase.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + 4), (int)(y + 4), (int)color.getRGB());
    }

    public static void renderBorder(PoseStack matrix, int xMin, int yMin, int xMax, int yMax, int borderThickness, DrawableColor borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        UIBase.renderBorder(matrix, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)borderThickness, borderColor.getColorInt(), renderTop, renderLeft, renderRight, renderBottom);
    }

    public static void renderBorder(PoseStack matrix, int xMin, int yMin, int xMax, int yMax, int borderThickness, Color borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        UIBase.renderBorder(matrix, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)borderThickness, borderColor.getRGB(), renderTop, renderLeft, renderRight, renderBottom);
    }

    public static void renderBorder(PoseStack pose, float xMin, float yMin, float xMax, float yMax, float borderThickness, int borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        if (renderTop) {
            RenderingUtils.fillF(pose, xMin, yMin, xMax, yMin + borderThickness, borderColor);
        }
        if (renderLeft) {
            RenderingUtils.fillF(pose, xMin, yMin + borderThickness, xMin + borderThickness, yMax - borderThickness, borderColor);
        }
        if (renderRight) {
            RenderingUtils.fillF(pose, xMax - borderThickness, yMin + borderThickness, xMax, yMax - borderThickness, borderColor);
        }
        if (renderBottom) {
            RenderingUtils.fillF(pose, xMin, yMax - borderThickness, xMax, yMax, borderColor);
        }
    }

    public static int drawElementLabelF(PoseStack pose, Font font, String text, float x, float y) {
        return UIBase.drawElementLabelF(pose, font, (Component)Components.literal(text), x, y);
    }

    public static int drawElementLabelF(PoseStack pose, Font font, Component text, float x, float y) {
        if (!FancyMenu.getOptions().enableUiTextShadow.getValue().booleanValue()) {
            return font.m_92889_(pose, text, x, y, UIBase.getUIColorTheme().element_label_color_normal.getColorInt());
        }
        return font.m_92763_(pose, text, x, y, UIBase.getUIColorTheme().element_label_color_normal.getColorInt());
    }

    public static int drawElementLabel(PoseStack pose, Font font, Component text, int x, int y) {
        return UIBase.drawElementLabel(pose, font, text, x, y, UIBase.getUIColorTheme().element_label_color_normal.getColorInt());
    }

    public static int drawElementLabel(PoseStack pose, Font font, String text, int x, int y) {
        return UIBase.drawElementLabel(pose, font, (Component)Components.literal(text), x, y, UIBase.getUIColorTheme().element_label_color_normal.getColorInt());
    }

    public static int drawElementLabel(PoseStack pose, Font font, Component text, int x, int y, int baseColor) {
        return FancyMenu.getOptions().enableUiTextShadow.getValue() != false ? font.m_92763_(pose, text, (float)x, (float)y, baseColor) : font.m_92889_(pose, text, (float)x, (float)y, baseColor);
    }

    public static int drawElementLabel(PoseStack pose, Font font, String text, int x, int y, int baseColor) {
        return UIBase.drawElementLabel(pose, font, (Component)Components.literal(text), x, y, baseColor);
    }

    @NotNull
    public static UIColorTheme getUIColorTheme() {
        return UIColorThemeRegistry.getActiveTheme();
    }
}

