/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.playerentity.model.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.model.PlayerEntityElementRenderer;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.model.PlayerEntityProperties;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.model.layers.PlayerEntityRenderLayer;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PlayerEntityShoulderParrotLayer
extends PlayerEntityRenderLayer {
    private final ParrotModel model;
    public final PlayerEntityProperties properties;

    public PlayerEntityShoulderParrotLayer(PlayerEntityElementRenderer renderer, EntityModelSet modelSet, PlayerEntityProperties properties) {
        super((RenderLayerParent)renderer);
        this.model = new ParrotModel(modelSet.m_171103_(ModelLayers.f_171203_));
        this.properties = properties;
    }

    public void m_6494_(PoseStack p_117307_, MultiBufferSource p_117308_, int p_117309_, @Nullable Entity entity, float p_117311_, float p_117312_, float p_117313_, float p_117314_, float p_117315_, float p_117316_) {
        if (this.properties.hasParrotOnShoulder) {
            this.render(p_117307_, p_117308_, p_117309_, p_117311_, p_117312_, p_117315_, p_117316_, this.properties.parrotOnLeftShoulder);
        }
    }

    private void render(PoseStack p_117318_, MultiBufferSource p_117319_, int p_117320_, float p_117322_, float p_117323_, float p_117324_, float p_117325_, boolean onLeftShoulder) {
        p_117318_.m_85836_();
        p_117318_.m_85837_(onLeftShoulder ? (double)0.4f : (double)-0.4f, this.properties.isCrouching() ? (double)-1.3f : -1.5, 0.0);
        Variant variant = Variant.byId(this.properties.shoulderParrotVariant);
        if (variant == null) {
            variant = Variant.RED_BLUE;
        }
        VertexConsumer vertexconsumer = p_117319_.m_6299_(this.model.m_103119_(ParrotVariants.getVariantTexture(variant)));
        this.model.m_103223_(p_117318_, vertexconsumer, p_117320_, OverlayTexture.f_118083_, p_117322_, p_117323_, p_117324_, p_117325_, this.properties.tickCount);
        p_117318_.m_85849_();
    }

    public static enum Variant {
        RED_BLUE(0),
        BLUE(1),
        GREEN(2),
        YELLOW_BLUE(3),
        GRAY(4);

        final int id;

        private Variant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public static Variant byId(int id) {
            for (Variant v : Variant.values()) {
                if (v.id != id) continue;
                return v;
            }
            return null;
        }
    }

    public static class ParrotVariants {
        private static final ResourceLocation RED_BLUE = new ResourceLocation("textures/entity/parrot/parrot_red_blue.png");
        private static final ResourceLocation BLUE = new ResourceLocation("textures/entity/parrot/parrot_blue.png");
        private static final ResourceLocation GREEN = new ResourceLocation("textures/entity/parrot/parrot_green.png");
        private static final ResourceLocation YELLOW_BLUE = new ResourceLocation("textures/entity/parrot/parrot_yellow_blue.png");
        private static final ResourceLocation GREY = new ResourceLocation("textures/entity/parrot/parrot_grey.png");

        public static ResourceLocation getVariantTexture(Variant variant) {
            return switch (variant) {
                default -> throw new IncompatibleClassChangeError();
                case Variant.RED_BLUE -> RED_BLUE;
                case Variant.BLUE -> BLUE;
                case Variant.GREEN -> GREEN;
                case Variant.YELLOW_BLUE -> YELLOW_BLUE;
                case Variant.GRAY -> GREY;
            };
        }
    }
}

