/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ElementMemories;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.properties.RuntimePropertyContainer;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElement
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry,
NavigatableWidget {
    public static final AbstractElement EMPTY_ELEMENT = new AbstractElement(null){

        @Override
        public void m_6305_(@NotNull PoseStack p, int i1, int i2, float f) {
        }
    };
    public static final int STAY_ON_SCREEN_EDGE_ZONE_SIZE = 2;
    public final ElementBuilder<?, ?> builder;
    public ElementAnchorPoint anchorPoint = ElementAnchorPoints.MID_CENTERED;
    public String anchorPointElementIdentifier = null;
    protected AbstractElement cachedElementAnchorPointParent = null;
    public int posOffsetX = 0;
    public int posOffsetY = 0;
    public int baseWidth = 0;
    public int baseHeight = 0;
    public String advancedX;
    public Integer cachedAdvancedX;
    public long lastAdvancedXParse = -1L;
    public String advancedY;
    public Integer cachedAdvancedY;
    public long lastAdvancedYParse = -1L;
    public String advancedWidth;
    public Integer cachedAdvancedWidth;
    public long lastAdvancedWidthParse = -1L;
    public String advancedHeight;
    public Integer cachedAdvancedHeight;
    public long lastAdvancedHeightParse = -1L;
    public boolean stretchX = false;
    public boolean stretchY = false;
    public boolean stayOnScreen = true;
    public volatile boolean visible = true;
    public volatile AppearanceDelay appearanceDelay = AppearanceDelay.NO_DELAY;
    public volatile float appearanceDelayInSeconds = 1.0f;
    public volatile boolean fadeIn = false;
    public volatile float fadeInSpeed = 1.0f;
    public volatile float opacity = 1.0f;
    public float customGuiScale = -1.0f;
    public LoadingRequirementContainer loadingRequirementContainer = new LoadingRequirementContainer();
    @Nullable
    public String customElementLayerName = null;
    private String instanceIdentifier;
    @Nullable
    protected Layout parentLayout;
    @Nullable
    protected RuntimePropertyContainer cachedMemory;

    public AbstractElement(@NotNull ElementBuilder<?, ?> builder) {
        this.builder = builder;
        this.instanceIdentifier = ScreenCustomization.generateUniqueIdentifier();
    }

    public void setParentLayout(@Nullable Layout parentLayout) {
        this.parentLayout = parentLayout;
    }

    @Nullable
    public Layout getParentLayout() {
        return this.parentLayout;
    }

    public abstract void m_6305_(@NotNull PoseStack var1, int var2, int var3, float var4);

    public void tick() {
    }

    public void onCloseScreen() {
    }

    public void onOpenScreen() {
    }

    public void onBeforeResizeScreen() {
    }

    public void onDestroyElement() {
    }

    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        return null;
    }

    @NotNull
    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public void setInstanceIdentifier(@NotNull String id) {
        this.instanceIdentifier = Objects.requireNonNull(id);
    }

    public int getAbsoluteX() {
        int x = 0;
        if (this.anchorPoint != null) {
            x = this.anchorPoint.getElementPositionX(this);
        }
        if (this.advancedX != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedXParse + 30L > now && this.cachedAdvancedX != null) {
                x = this.cachedAdvancedX;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedX).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    x = (int)Double.parseDouble(s);
                    this.cachedAdvancedX = x;
                    this.lastAdvancedXParse = now;
                }
            }
        }
        if (this.stretchX) {
            x = 0;
        } else if (this.stayOnScreen) {
            if (x < 2) {
                x = 2;
            }
            if (x > AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth()) {
                x = AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth();
            }
        }
        return x;
    }

    public int getAbsoluteY() {
        int y = 0;
        if (this.anchorPoint != null) {
            y = this.anchorPoint.getElementPositionY(this);
        }
        if (this.advancedY != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedYParse + 30L > now && this.cachedAdvancedY != null) {
                y = this.cachedAdvancedY;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedY).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    y = (int)Double.parseDouble(s);
                    this.cachedAdvancedY = y;
                    this.lastAdvancedYParse = now;
                }
            }
        }
        if (this.stretchY) {
            y = 0;
        } else if (this.stayOnScreen) {
            if (y < 2) {
                y = 2;
            }
            if (y > AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight()) {
                y = AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight();
            }
        }
        return y;
    }

    public int getAbsoluteWidth() {
        if (this.advancedWidth != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedWidthParse + 30L > now && this.cachedAdvancedWidth != null) {
                return this.cachedAdvancedWidth;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedWidth).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedWidth = (int)Double.parseDouble(s);
                this.lastAdvancedWidthParse = now;
                return this.cachedAdvancedWidth;
            }
        }
        if (this.stretchX) {
            return AbstractElement.getScreenWidth();
        }
        return this.baseWidth;
    }

    public int getAbsoluteHeight() {
        if (this.advancedHeight != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedHeightParse + 30L > now && this.cachedAdvancedHeight != null) {
                return this.cachedAdvancedHeight;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedHeight).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedHeight = (int)Double.parseDouble(s);
                this.lastAdvancedHeightParse = now;
                return this.cachedAdvancedHeight;
            }
        }
        if (this.stretchY) {
            return AbstractElement.getScreenHeight();
        }
        return this.baseHeight;
    }

    @Nullable
    public AbstractElement getElementAnchorPointParent() {
        if (this.anchorPointElementIdentifier == null) {
            return null;
        }
        if (this.cachedElementAnchorPointParent == null) {
            this.cachedElementAnchorPointParent = AbstractElement.getElementByInstanceIdentifier(this.anchorPointElementIdentifier);
        }
        return this.cachedElementAnchorPointParent;
    }

    public void setElementAnchorPointParent(@Nullable AbstractElement element) {
        this.cachedElementAnchorPointParent = element;
    }

    public int getChildElementAnchorPointX() {
        return this.getAbsoluteX();
    }

    public int getChildElementAnchorPointY() {
        return this.getAbsoluteY();
    }

    public boolean shouldRender() {
        if (!this.loadingRequirementsMet()) {
            return false;
        }
        return this.visible;
    }

    protected boolean loadingRequirementsMet() {
        if (AbstractElement.isEditor()) {
            return true;
        }
        return this.loadingRequirementContainer.requirementsMet();
    }

    @NotNull
    public Component getDisplayName() {
        if (this.customElementLayerName != null) {
            return Components.literal(this.customElementLayerName);
        }
        return this.builder.getDisplayName(this);
    }

    @NotNull
    public RuntimePropertyContainer getMemory() {
        if (this.cachedMemory == null) {
            this.cachedMemory = ElementMemories.getMemory(this.getInstanceIdentifier());
        }
        return this.cachedMemory;
    }

    public static String fixBackslashPath(String path) {
        if (path != null) {
            return path.replace("\\", "/");
        }
        return null;
    }

    protected static boolean isEditor() {
        return AbstractElement.getScreen() instanceof LayoutEditorScreen;
    }

    @Nullable
    public static Screen getScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    public static int getScreenWidth() {
        Screen s = AbstractElement.getScreen();
        return s != null ? s.f_96543_ : 0;
    }

    public static int getScreenHeight() {
        Screen s = AbstractElement.getScreen();
        return s != null ? s.f_96544_ : 0;
    }

    @Nullable
    public static AbstractElement getElementByInstanceIdentifier(String identifier) {
        identifier = identifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        if (AbstractElement.isEditor()) {
            AbstractEditorElement editorElement = ((LayoutEditorScreen)AbstractElement.getScreen()).getElementByInstanceIdentifier(identifier);
            if (editorElement != null) {
                return editorElement.element;
            }
        } else {
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
            if (layer != null) {
                return layer.getElementByInstanceIdentifier(identifier);
            }
        }
        return null;
    }

    @NotNull
    public static Component buildComponent(@NotNull String serializedComponentOrPlainText) {
        if (!(serializedComponentOrPlainText = PlaceholderParser.replacePlaceholders(serializedComponentOrPlainText)).startsWith("{")) {
            return Components.literal(serializedComponentOrPlainText);
        }
        try {
            MutableComponent c = Component.Serializer.m_130701_((String)serializedComponentOrPlainText);
            if (c != null) {
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Components.literal(serializedComponentOrPlainText);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("AbstractElements are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("AbstractElements are not navigatable!");
    }

    public static enum AppearanceDelay {
        NO_DELAY("no_delay"),
        FIRST_TIME("first_time"),
        EVERY_TIME("every_time");

        public final String name;

        private AppearanceDelay(String name) {
            this.name = name;
        }

        @Nullable
        public static AppearanceDelay getByName(@NotNull String name) {
            for (AppearanceDelay d : AppearanceDelay.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }

        public static Alignment getByName(@NotNull String name) {
            for (Alignment a : Alignment.values()) {
                if (!a.key.equals(name)) continue;
                return a;
            }
            return null;
        }
    }
}

