/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.mixin;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.rabbitminers.extendedgears.cogwheels.CogwheelModelKey;
import com.rabbitminers.extendedgears.cogwheels.CogwheelType;
import com.rabbitminers.extendedgears.cogwheels.DynamicCogwheelRenderer;
import com.rabbitminers.extendedgears.cogwheels.HalfShaftCogwheelBlock;
import com.rabbitminers.extendedgears.mixin_interface.CogwheelTypeProvider;
import com.rabbitminers.extendedgears.mixin_interface.IDynamicMaterialBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.CachedBufferer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BracketedKineticBlockEntityInstance.class})
public abstract class MixinBracketedKineticBlockEntityInstance
extends SingleRotatingInstance<BracketedKineticBlockEntity> {
    @Shadow
    protected RotatingData additionalShaft;
    @Nullable
    protected CogwheelModelKey key;
    protected boolean large;

    @Shadow
    protected abstract PoseStack rotateToAxis(Direction.Axis var1);

    public MixinBracketedKineticBlockEntityInstance(MaterialManager materialManager, BracketedKineticBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(MaterialManager materialManager, BracketedKineticBlockEntity blockEntity, CallbackInfo ci) {
        if (blockEntity instanceof IDynamicMaterialBlockEntity) {
            IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)blockEntity;
            if (!blockEntity.m_58900_().m_60713_((Block)AllBlocks.SHAFT.get())) {
                this.large = ICogWheel.isLargeCog((BlockState)this.blockState);
                this.key = new CogwheelModelKey(this.large, this.getRenderedBlockState(), dynamicMaterialBlockEntity.getMaterial());
            }
        }
    }

    @Overwrite(remap=false)
    public void init() {
        super.init();
        if (!(this.blockState.m_60734_() instanceof CogWheelBlock)) {
            return;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        float speed = ((BracketedKineticBlockEntity)this.blockEntity).getSpeed();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos);
        boolean isHalfShaft = this.blockState.m_60734_() instanceof HalfShaftCogwheelBlock;
        Direction.AxisDirection direction = isHalfShaft ? HalfShaftCogwheelBlock.getAxisDirection(this.blockState) : Direction.AxisDirection.POSITIVE;
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)direction);
        @Nullable PartialModel shaftModel = this.getShaftModel(this.blockState.m_60734_());
        if (shaftModel == null) {
            return;
        }
        Instancer half = this.getRotatingMaterial().getModel(shaftModel, this.blockState, facing, () -> isHalfShaft ? this.rotateToAxis(axis, direction) : this.rotateToAxis(axis));
        this.additionalShaft = this.setup((RotatingData)half.createInstance(), speed);
        this.additionalShaft.setRotationOffset(offset);
    }

    private PoseStack rotateToAxis(Direction.Axis axis, Direction.AxisDirection direction) {
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)direction);
        PoseStack poseStack = new PoseStack();
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing.m_122424_())).unCentre();
        return poseStack;
    }

    @Nullable
    public PartialModel getShaftModel(Block block) {
        if (!(block instanceof CogwheelTypeProvider)) {
            return AllPartialModels.COGWHEEL_SHAFT;
        }
        CogwheelTypeProvider provider = (CogwheelTypeProvider)block;
        return switch (provider.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CogwheelType.STANDARD -> AllPartialModels.COGWHEEL_SHAFT;
            case CogwheelType.HALF_SHAFT -> AllPartialModels.SHAFT_HALF;
            case CogwheelType.SHAFLTESS -> null;
        };
    }

    public boolean shouldReset() {
        boolean changed = false;
        BlockEntity blockEntity = this.blockEntity;
        if (blockEntity instanceof IDynamicMaterialBlockEntity) {
            IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)blockEntity;
            if (this.key != null) {
                changed = this.key.material() != dynamicMaterialBlockEntity.getMaterial();
            }
        }
        return super.shouldReset() || changed;
    }

    protected Instancer<RotatingData> getModel() {
        if (this.key == null) {
            return super.getModel();
        }
        return this.getRotatingMaterial().model((Object)this.key, () -> {
            BakedModel model = DynamicCogwheelRenderer.generateModel(this.key);
            BlockState state = this.key.state();
            Direction.AxisDirection axisDirection = state.m_60734_() instanceof HalfShaftCogwheelBlock ? HalfShaftCogwheelBlock.getAxisDirection(state) : Direction.AxisDirection.POSITIVE;
            Direction dir = Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS)), (Direction.AxisDirection)axisDirection);
            PoseStack transform = (PoseStack)CachedBufferer.rotateToFaceVertical((Direction)dir).get();
            return BlockModel.of((BakedModel)model, (BlockState)Blocks.f_50016_.m_49966_(), (PoseStack)transform);
        });
    }
}

