/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.mixin;

import com.rabbitminers.extendedgears.base.util.MaterialHelpers;
import com.rabbitminers.extendedgears.cogwheels.materials.CogwheelMaterialManager;
import com.rabbitminers.extendedgears.mixin_interface.IDynamicMaterialBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BracketedKineticBlockEntity.class})
public class MixinBracketedKineticBlockEntity
extends SimpleKineticBlockEntity
implements IDynamicMaterialBlockEntity {
    @Unique
    public ResourceLocation material = RegisteredObjects.getKeyOrThrow((Block)Blocks.f_50741_);

    public MixinBracketedKineticBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public ResourceLocation getMaterial() {
        return this.material;
    }

    @Override
    public InteractionResult applyMaterialIfValid(ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        @Nullable ResourceLocation material = MaterialHelpers.getModelKey(stack, this.material);
        if (material == null) {
            return InteractionResult.PASS;
        }
        this.material = material;
        this.notifyUpdate();
        this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)this.m_58900_()));
        return InteractionResult.SUCCESS;
    }

    @Override
    public void applyMaterial(ResourceLocation material) {
        this.material = material;
    }

    public void lazyTick() {
        boolean shouldBreak;
        if (this.material == null || this.f_58857_ == null) {
            return;
        }
        boolean bl = shouldBreak = Math.abs(this.speed) > (float)CogwheelMaterialManager.getSpeedLimit(this.material) || Math.abs(this.capacity) > (float)CogwheelMaterialManager.getStressLimit(this.material);
        if (shouldBreak) {
            this.f_58857_.m_46961_(this.f_58858_, true);
        }
    }

    protected void redraw() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        ResourceLocation prevMaterial = this.material;
        if (!compound.m_128441_("Material")) {
            return;
        }
        this.material = NBTHelper.readResourceLocation((CompoundTag)compound, (String)"Material");
        if (this.material == null) {
            this.material = RegisteredObjects.getKeyOrThrow((Block)Blocks.f_50741_);
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        NBTHelper.writeResourceLocation((CompoundTag)compound, (String)"Material", (ResourceLocation)this.material);
    }
}

